package com.ibm.lab.extensionpoint;

/**
 * ExtensionProcessor processes the subtags of the 
 * "com.ibm.lab.extensionpoint.toolAction" extension point.
 * 
 * See plugin.xml for example usage.
 */

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionProcessor {
	// Plug-in ID from <plugin> tag in plugin.xml
	private static final String PLUGIN_ID =
		"com.ibm.lab.extensionpoint";
	// Extension point ID from the <extension-point> tag in plugin.xml
	private static final String EXTENSION_POINT_ID = "toolAction";
	// Name of the tag to process
	private static final String EXTENSION_TAG = "tool";
	// Name of the attribute holding the class to do an action
	private static final String EXTENSION_TAG_ACTION_ATTRIB = "action";
	// Name of the attribute holding the label for the action
	private static final String EXTENSION_TAG_LABEL_ATTRIB = "label";

	private IExtensionPoint point;  				// replace with correct code
	private IPluginRegistry pluginRegistry;		// replace with correct code
	
	private List toolActionsParameters = new ArrayList();

	public ExtensionProcessor() {
		super();
	}

	protected void setToolActionsParameters(List newToolActions) {
		toolActionsParameters = newToolActions;
	}

	protected List getToolActionsParameters() {
		return toolActionsParameters;
	}

	private void addMenuItem(IConfigurationElement configElement) {
		System.out.print("Loading tag...");


//		try {
			// create an instance of the class specified in the action attribute
			IToolAction toolAction = null; 	// replace with correct code
			String label = null;				// replace with correct code

			// search for double entries
			boolean doubleEntry = false;
			for (int i = 0; i < getToolActionsParameters().size(); i++) {
				ToolActionParameters toolActionParameters =
					(ToolActionParameters) getToolActionsParameters().get(i);
				if (toolActionParameters.getActionLabel().equals(label))
					doubleEntry = true;
			}

			// we take the first matching label
			if (!doubleEntry) {
				getToolActionsParameters().add(new ToolActionParameters(toolAction, label));
				System.out.println("...success!");
			} else {
				System.out.println(
					"...failed! Reason: Label '"
						+ label
						+ "' already exists.  Check your plugin.xml");
			}

			System.out.println(
				"Details: "
					+ EXTENSION_TAG_ACTION_ATTRIB
					+ ": "
					+ configElement.getAttribute(EXTENSION_TAG_ACTION_ATTRIB)
					+ ", "
					+ EXTENSION_TAG_LABEL_ATTRIB
					+ ": "
					+ configElement.getAttribute(EXTENSION_TAG_LABEL_ATTRIB));
//		} catch (CoreException e) {
			// this exception occurs mostly when the class attribute value
			// could not be instantiated (maybe a typing error in class name)
//			System.out.print("...failed! Reason: " + e.getLocalizedMessage());
//		}

	}

	public void load() {
		System.out.println("*Action Configuration Start*");

		// check: Any <extension> tags for our extension-point?
		if (point != null) {
			// insert code here
		}

		// Check if no extensions or empty extensions
		if (point == null || getToolActionsParameters().size() == 0) {
			System.out.println("* No configuration found!");
		}

		System.out.println("*Action Configuration End*");
	}
}