package com.ibm.lab.soln.resources;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.ibm.lab.soln.resources.markers.RecentEditsRCL;

/**
 * The plugin class for the Resource Programming Plugin. 
 * Instantiated by the platform when the plug-in is started.
 * <p>
 * Note: The plug-in class name is EDUResourcePlugin to 
 * avoid a name collision and confusion with the 
 * platform Resources Plug-in (see getWorkspace() method).
 * </p>
 */
public class EDUResourcesPlugin
  extends AbstractUIPlugin
  implements IStartup {

  //Reference to the shared instance, returned when requested.
  private static EDUResourcesPlugin plugin;
  //Resource bundle.
  private ResourceBundle resourceBundle;
  // hold RCL for later removal   
  private IResourceChangeListener myListener = null;
  // RCL added/removed indicator   
  boolean my_Rcl_Added = false;

  /**
   * The constructor.
   */
  public EDUResourcesPlugin(IPluginDescriptor descriptor) {
    super(descriptor);
    plugin = this;
    try {
      resourceBundle =
        ResourceBundle.getBundle(
          "com.ibm.lab.soln.resources.ResourcesPluginResources");
    } catch (MissingResourceException x) {
      resourceBundle = null;
    }
  }

  /**
   * Method triggered when the plug-in started by Eclipse. Adds the 
   * recent edits resource change listener (see <code>RecentEditsRCL</code>)
   * and workspace save participant (see <code>WorkspaceSaveParticipant</code>).
   */
  public void startup() throws CoreException {
    // need to send super to ensure framework methods are invoked.
    super.startup();

    // Add recent edits resource change listener 
    addMy_RE_RCL();

    // Add tracing resource change listener - writes to console when 
    // tracing is enabled. 

    // Remove comment if you want this to be active by default.
    // Can also be added using Soln: Resource Tools / Soln: Add Tracing RCL
    // context menu option in Navigator view
          addMy_RCL();

    // Add save participant
    // Can be commented out to disable the save participant.
//    addMy_SaveP();
  }

  /**
   * Method Stub.  Does nothing specific, but supports immediate integration of 
   * plug-in into the running Workbench.
   * @see org.eclipse.ui.IStartup#earlyStartup()
   */
  public void earlyStartup() {
    // All work is done in the startup() method

  }

  /**
   * Adds a workspace resource change listener when called 
   * by this plug-in's startup() method.
   * 
   * Multiple approaches to adding an RCL, with all or selected event types 
   * identified, are included in the method source.
   */
  public void addMy_RE_RCL() {
    IResourceChangeListener listener = new RecentEditsRCL();

    getWorkspace().addResourceChangeListener(
      listener,
      IResourceChangeEvent.POST_AUTO_BUILD);
  }

  /**
   * Adds a workspace resource change listener when called 
   * by the <code>ActionManageTraceRCLs</code> logic.
   * 
   * Multiple approaches to adding an RCL, with all or selected event types 
   * identified, are included in the method source.
   */
  public boolean addMy_RCL() throws CoreException {

    if (!my_Rcl_Added) {
      // create listener and add to workspace for all event types
      myListener = new ResourceChangeReporter();

      getWorkspace().addResourceChangeListener(
        myListener,
//        IResourceChangeEvent.PRE_CLOSE
//          | IResourceChangeEvent.PRE_DELETE
//          | IResourceChangeEvent.PRE_AUTO_BUILD
//          | IResourceChangeEvent.POST_AUTO_BUILD
           IResourceChangeEvent.POST_CHANGE);
      my_Rcl_Added = true;

      // this method would do the same as listing all five event types shown above
      //ResourcesPlugin.getWorkspace().addResourceChangeListener(myListener);

      // Logic to add separate listeners for each event type
      /*	IResourceChangeListener listener1 = new 
      		MyResourceChangeReporter("PRE_CLOSE");
      	ResourcesPlugin.getWorkspace().addResourceChangeListener(
      		listener1, IResourceChangeEvent.PRE_CLOSE);
      
      	IResourceChangeListener listener2 = new 
      		MyResourceChangeReporter("PRE_DELETE");
      	ResourcesPlugin.getWorkspace().addResourceChangeListener(
      		listener2, IResourceChangeEvent.PRE_DELETE);
      
      	IResourceChangeListener listener3 = new 
      		MyResourceChangeReporter("PRE_AUTO_BUILD");
      	ResourcesPlugin.getWorkspace().addResourceChangeListener(
      		listener3, IResourceChangeEvent.PRE_AUTO_BUILD);
      
      	IResourceChangeListener listener4 = new 
      		MyResourceChangeReporter("POST_AUTO_BUILD");
      	ResourcesPlugin.getWorkspace().addResourceChangeListener(
      		listener4, IResourceChangeEvent.POST_AUTO_BUILD);
      
      	IResourceChangeListener listener5 = new 
      		MyResourceChangeReporter("POST_CHANGE");
      	ResourcesPlugin.getWorkspace().addResourceChangeListener(
      		listener5, IResourceChangeEvent.POST_CHANGE);
      	*/
      return true;
    }
    return false;
  }
  /**
   * Removes an existing workspace resource change listener when called 
   * by the <code>ActionManageTraceRCLs</code> logic.
   * 
   * Multiple approaches to adding an RCL, with all or selected event types 
   * identified, are included in the method source.
   */
  boolean removeMy_RCL() throws CoreException {

    if ((myListener != null) & my_Rcl_Added) {
      getWorkspace().removeResourceChangeListener(myListener);
      my_Rcl_Added = false;
      return true;
    }
    return false;
  }
  /**
   * Adds a workspace save participant when called 
   * by this plug-ins startup() method.
   * 
   * Save participant logic can interpret the returned saved state.
   * A null saved state can be returned the first time a save participant is added.
   * 
   * If requested during a previous save event, a resource delta with changes 
   * since the last save is returned.
   */
  public void addMy_SaveP() throws CoreException {

    // create save participant and add to workspace for all event types
    ISaveParticipant saveParticipant = new WorkspaceSaveParticipant();

    ISavedState lastState =
      getWorkspace().addSaveParticipant(plugin, saveParticipant);

    if (lastState == null) {
      // activate for very first time
      //		plugin.buildState();
    } else {
      String saveFileName = lastState.lookup(new Path("save")).toString();
      File f = plugin.getStateLocation().append(saveFileName).toFile();
      //instance.readImportantState(f);
      lastState.processResourceChangeEvents(
        new ResourceChangeReporter("WkSavePart ->: Event: "));
    }
  }

  /**
   * Returns the shared instance.
   */
  public static EDUResourcesPlugin getDefault() {
    return plugin;
  }

  /**
   * Returns the workspace instance using the platform 
   * implementation of the Resources plugin.
   * (names happen to be the same).
   */
  public static IWorkspace getWorkspace() {
    return org.eclipse.core.resources.ResourcesPlugin.getWorkspace();
  }

  /**
   * Returns the string from the plugin's resource bundle,
   * or 'key' if not found.
   */
  public static String getResourceString(String key) {
    ResourceBundle bundle = getDefault().getResourceBundle();
    try {
      return bundle.getString(key);
    } catch (MissingResourceException e) {
      return key;
    }
  }

  /**
   * Returns the plugin's resource bundle,
   */
  public ResourceBundle getResourceBundle() {
    return resourceBundle;
  }

}