package com.ibm.lab.soln.contributions;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;


/**
 * This action will collapse the selected nodes of the TreeViewer 
 * supplied by its subclass. If no nodes are selected, it will 
 * collapse the entire tree.
 * 
 * Subclasses must extend the abstract method getViewer which provides the 
 * TreeViewer on which to perform the collapse nodes operation. 
 * @see org.eclipse.ui.IViewActionDelegate
 */
public abstract class TreeViewerCollapseNodesAction implements IViewActionDelegate {
	IViewPart view;

	public TreeViewerCollapseNodesAction() {
		super();
	}

	/**
	 * Collapses the expanded nodes of the viewer.
   * @see org.eclipse.ui.IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		TreeViewer treeViewer = getTreeViewer();
		IStructuredSelection ss =
			(IStructuredSelection) treeViewer.getSelection();

		if (ss.isEmpty()) {
			treeViewer.collapseAll();
			return;
		}

		for (Iterator iterator = ss.iterator(); iterator.hasNext();) {
			Object element = iterator.next();
			if (treeViewer.getExpandedState(element)) {
				treeViewer.collapseToLevel(element, TreeViewer.ALL_LEVELS);
			} else
				treeViewer.collapseAll();
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * Save a reference to the view.
   * @see org.eclipse.ui.IViewActionDelegate#init(IViewPart)
	 */
	public void init(IViewPart vp) {
		view = vp;
	}

	/**
	 * Subclass must override this method.
   * @return org.eclipse.jface.viewers.TreeViewer
	 */
	protected abstract TreeViewer getTreeViewer();
}