package com.ibm.lab.soln.contributions;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.views.navigator.ResourceNavigator;

/**
 * An action contribution is defined for the Navigator view that will 
 * collapse the expanded nodes of its tree viewer. It relies on the 
 * abstract class TreeViewerCollapseNodesAction to do the work.
 * See Chapter 18 for a discussion of the implementation.
 * @see TreeViewerCollapseNodesAction
 */
public class ResourceNavigatorCollapseNodesAction
	extends TreeViewerCollapseNodesAction {
		
	/**
   * Returns this view's TreeViewer which required by the parent 
   * abstract class TreeViewerCollapseNodesAction. 
   */
	protected TreeViewer getTreeViewer() {
		return ((ResourceNavigator) view).getTreeViewer();
	}		
}
