package com.ibm.lab.soln.sqleditor.sql;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;

import com.ibm.lab.soln.sqleditor.SQLEditorPlugin;
import com.ibm.lab.soln.sqleditor.utils.ColorProvider;
import com.ibm.lab.soln.sqleditor.utils.SQLWhiteSpaceDetector;
import com.ibm.lab.soln.sqleditor.utils.SQLWordDetector;

/**
 * The SQLCodeScanner is a RuleBaseScanner.This class finds SQL comments and
 * keywords, as the user edits the document. It is "programmed" with a sequence
 * of rules that evaluates and returns the offset and the length of the last
 * found token.
 */
public class SQLCodeScanner extends RuleBasedScanner implements ISQLSyntax{

	/**
	 * Constructor for SQLCodeScanner.
	 * The SQLCodeScanner, is a RuleBaseScanner. The code scanner creates tokens 
	 * for keywords, types, and constants. The token is constructed with a 
	 * TextAttribute. The TextAttribute is constructed with a color and font. 
	 * A list of rules with the corresponding token are created. The method ends
	 * with setting the scanners set of rules
	 */
	public SQLCodeScanner() {
		ColorProvider provider =
			SQLEditorPlugin.getDefault().getColorProvider();
		IToken keyword =
			new Token(
				new TextAttribute(
					provider.getColor(ColorProvider.KEYWORD),
					provider.getColor(ColorProvider.BACKGROUND),
					SWT.BOLD));
		IToken type =
			new Token(
				new TextAttribute(
					provider.getColor(ColorProvider.TYPE),
					provider.getColor(ColorProvider.BACKGROUND),
					SWT.BOLD));
		IToken string =
			new Token(
				new TextAttribute(provider.getColor(ColorProvider.STRING)));
		IToken comment =
			new Token(
				new TextAttribute(
					provider.getColor(ColorProvider.SINGLE_LINE_COMMENT)));
		IToken other =
			new Token(
				new TextAttribute(provider.getColor(ColorProvider.DEFAULT)));

		setDefaultReturnToken(other);
		List rules = new ArrayList();

		// Add rule for single line comments.
		rules.add(new EndOfLineRule("//", comment));

		// Add rule for strings and character constants.
		rules.add(new SingleLineRule("\"", "\"", string, '\\'));
		rules.add(new SingleLineRule("'", "'", string, '\\'));

		// Add generic whitespace rule.
		rules.add(new WhitespaceRule(new SQLWhiteSpaceDetector()));

		// Add word rule for keywords, types, and constants.
		WordRule wordRule = new WordRule(new SQLWordDetector(), other);
		for (int i = 0; i < reservedwords.length; i++)
			wordRule.addWord(reservedwords[i], keyword);
		for (int i = 0; i < types.length; i++)
			wordRule.addWord(types[i], type);
		for (int i = 0; i < constants.length; i++)
			wordRule.addWord(constants[i], type);
		rules.add(wordRule);

		IRule[] result = new IRule[rules.size()];
		rules.toArray(result);
		setRules(result);

	}

}
