package com.ibm.lab.soln.sqleditor;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import java.util.ResourceBundle;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditorActionDefinitionIds;
import org.eclipse.ui.texteditor.TextOperationAction;

import com.ibm.lab.soln.sqleditor.sql.SQLCodeScanner;

/**
 *	This class is responsible for configuring the SQL editor.
 *  
 */
public class SQLEditor extends AbstractTextEditor {
	private static SQLCodeScanner fSQLCodeScanner;
	/**
	 * Constructor for SQLEditor. Intialization takes place in the constructor 
	 * of SQLEditor using setDocumentProvider and setRangeIndicator.
	 */
	public SQLEditor() {
		super();
		setDocumentProvider(new SQLEditorDocumentProvider());
		setSourceViewerConfiguration(new SQLEditorSourceViewerConfiguration());
		fSQLCodeScanner = new SQLCodeScanner();
		setRangeIndicator(new DefaultRangeIndicator());

	}
	/**
	 * Clean up the font colors used in the syntax hilighting
	 *  
	 */
	public void disposeColorProvider() {
		SQLEditorPlugin.getDefault().disposeColorProvider();
		super.dispose();
	}

	/**
	 * Method to install the editor actions.
	 * 
	 * @see org.eclipse.ui.texteditor.AbstractTextEditor#createActions()
	 * 
	 * Changes required in V 2.1. Shortcut keys on global actions must be explicitly set.  
	 * Content Assist and Context Information Shortcut keys must be set to the key 
	 * defintion ID's. 
	 */
	protected void createActions() {
		// Added in 2.1,  global action revert, undo etc. are otherwise not enabled  
		super.createActions();
		// Above is new line reqired in 2.1 to enable undo, redo, revert actions

		ResourceBundle bundle =
			SQLEditorPlugin.getDefault().getResourceBundle();
	IAction a =
			new TextOperationAction(
				bundle,
				"ContentAssistProposal.",
				this,
				ISourceViewer.CONTENTASSIST_PROPOSALS);
// Added this call for 2.1 changes
// New to 2.1 - CTRL+Space key doesn't work without making this call 	
				
		a.setActionDefinitionId(
			ITextEditorActionDefinitionIds.CONTENT_ASSIST_PROPOSALS);
		setAction("ContentAssistProposal", a);
		a =
			new TextOperationAction(
				bundle,
				"ContentAssistTip.",
				this,
				ISourceViewer.CONTENTASSIST_CONTEXT_INFORMATION);
//		Added this call for 2.1 changes				
				
		a.setActionDefinitionId(
			ITextEditorActionDefinitionIds.CONTENT_ASSIST_CONTEXT_INFORMATION);
		setAction("ContentAssistTip", a);
		a =
			new TextOperationAction(
				bundle,
				"ContentFormatProposal.",
				this,
				ISourceViewer.FORMAT);
		setAction("ContentFormatProposal", a);
	}

	/**
	 * Getter method that returns a  SQL Code Scanner.
	 * @return SQLCodeScanner
	 */
	public static SQLCodeScanner getSQLCodeScanner() {
		return fSQLCodeScanner;
	}

}
