package com.ibm.lab.soln.swing.internalLaunch.extras;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;

import com.ibm.lab.soln.swing.internalApplication.ABCEditor;

import java.util.*;

/**
 * The main plugin class used to mediate the communications to and 
 * from the ABCEditor  
 */
public class SwingEditorPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static SwingEditorPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;

	private boolean workSpaceChanged = false;

	/**
	 * The constructor.
	 */
	public SwingEditorPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle =
				ResourceBundle.getBundle(
					"com.ibm.lab.soln.swing.internalLaunch.extras.SwingEditorPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance of the plug-in.
	 */
	public static SwingEditorPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle =
			SwingEditorPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	/**
	 * Returns the ABCEditor.
	 * @return ABCEditor
	 */
	public ABCEditor getAbcEditor() {
		ABCEditor abcEditor = new ABCEditor("Internal Launch : ");

		return abcEditor;
	}

	/**
	 * Method used to communicate workspace updates to Eclipse 
	 */
	public void updateWorkspace(IFile file) {
		try {
			if (file != null)
				file.getParent().refreshLocal(IResource.DEPTH_ONE, null);
			workSpaceChanged = true;
		} catch (Exception e) {
			e.printStackTrace();

		}
	}

	/**
	 * A method to save the workspace
	 */
	public void saveWorkspace() throws CoreException {
		if (workSpaceChanged) {
			ResourcesPlugin.getWorkspace().save(true, null);
		}

	}
}