package com.ibm.lab.soln.swing.internalApplication;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;

/** A simple dialog configured as a wizard that asks for some
 * information and uses it to create and initialize a new .abc
 * file.
 */
import javax.swing.JDialog;
public class NewABCFileWizard extends JDialog {
	private int currentPage = 1;
	private final int numPages = 2;

	// the file .abc file the wizard creates
	private String newFileName = "newFile";
	
	public NewABCFileWizard(Frame owner) {
		super(owner, "New", true);
		
		setModal(true);
		
		Container contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		
		// The top label area of the wizard
		Box labelArea = Box.createVerticalBox();
		labelArea.setBackground(Color.white);
		labelArea.add(new Label("ABC File"));
		labelArea.add(new Label("  Create a new .abc file"));
		contentPane.add(labelArea, "North");
		
		// the middle page content area of the wizard
		final JPanel pagesPane = new JPanel();
		final CardLayout pages = new CardLayout();
		pagesPane.setLayout(pages);
		contentPane.add(pagesPane, "Center");
		
		// page 1
		JPanel page1 = new JPanel();
		page1.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0; constraints.gridy = 0;
        constraints.anchor = GridBagConstraints.NORTHEAST;
        constraints.insets = new Insets(4, 4, 4, 4);
        page1.add(new JLabel("File name:"), constraints);

        constraints.gridx = 0; constraints.gridy = 1;
		page1.add(new JLabel("email address:"), constraints);

        constraints.gridx = 1; constraints.gridy = 0;
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 1.0;
		final JTextField fileNameField = new JTextField();
		page1.add(fileNameField, constraints);

        constraints.gridx = 1; constraints.gridy = 1;
		final JTextField emailField = new JTextField();
		page1.add(emailField, constraints);
		pagesPane.add("page1", page1);

		// page 2
		JPanel page2 = new JPanel();
		page2.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0; constraints.gridy = 0;
        constraints.anchor = GridBagConstraints.NORTHEAST;
        constraints.insets = new Insets(4, 4, 4, 4);
        page2.add(new JLabel("Name:"), constraints);

        constraints.gridx = 0; constraints.gridy = 1;
		page2.add(new JLabel("Location:"), constraints);

        constraints.gridx = 1; constraints.gridy = 0;
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 1.0;
		final JTextField nameField = new JTextField();
		page2.add(nameField, constraints);

        constraints.gridx = 1; constraints.gridy = 1;
		final JTextField locationInfoField = new JTextField();
		page2.add(locationInfoField, constraints);
		pagesPane.add("page2", page2);

		pagesPane.setBorder(LineBorder.createGrayLineBorder());
		
		// the bottom button area of the wizard
		JPanel buttonArea = new JPanel();
		buttonArea.setLayout(new FlowLayout(FlowLayout.RIGHT));
		contentPane.add(buttonArea, "South");
		final JButton backButton = new JButton("Back");
		final JButton nextButton = new JButton("Next");
		backButton.setEnabled(false);
		backButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				pages.previous(pagesPane);
				currentPage--;
				if (currentPage == 1) {
					nextButton.setEnabled(true);
					backButton.setEnabled(false);
				}
			}
		});
		buttonArea.add(backButton);
		nextButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				pages.next(pagesPane);
				currentPage++;
				if (currentPage == numPages) {
					nextButton.setEnabled(false);
					backButton.setEnabled(true);
				}
			}
		});
		buttonArea.add(nextButton);
		JButton finishButton = new JButton("Finish");
		finishButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				newFileName = null;
        		try {
        			String fileName = fileNameField.getText();
        			if (fileName.equals("")) {
        				return;
        			}
        			fileName = fileName+".abc";
			    	PrintWriter out = new PrintWriter(new FileWriter(fileName));
        			out.println("email:\t"+emailField.getText());
        			out.println("name:\t"+nameField.getText());
        			out.println("location:\t"+locationInfoField.getText());
        			out.close();
        			newFileName = fileName;
        		} catch (Exception exc) {
        			exc.printStackTrace();
        		}
				NewABCFileWizard.this.setVisible(false);
			}
		});
		buttonArea.add(finishButton);
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				NewABCFileWizard.this.setVisible(false);
			}
		});
		buttonArea.add(cancelButton);
		
		pack();
		setSize(350, 220);
	}

	/** Get the name of the file created by the wizard.
	 * @return the name of the created file or null if no
	 *   file was created
	 */
	public File getFile() {
		return new File(newFileName);
	}
}
