/*
 * "The Java Developer's Guide to Eclipse"
 * 
 * (C) Copyright International Business Machines Corporation, 2003.
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
package com.ibm.lab.soln.jface;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class MembersDialogAction
	implements IObjectActionDelegate, IWorkbenchWindowActionDelegate {

	private ISelection selection;

	/**
		 * Constructor for Action1.
		 */
	public MembersDialogAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		// Auto-generated method stub

	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	//	Edu-Sol: 01  - Create dialog with a reference to the selected folder 
	public void run(IAction action) {
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

		// Open dialog
		IStructuredSelection resSelection = (IStructuredSelection) selection;

		// Treat IFolder as IContainer - required by JFaceComponent
		IContainer readmeFolder = (IContainer) resSelection.getFirstElement();
		MembersDialog jdialog = new MembersDialog(shell, readmeFolder);
		jdialog.open();

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		// Auto-generated method stub

	}
}
