/*
 * "The Java Developer's Guide to Eclipse"
 * 
 * (C) Copyright International Business Machines Corporation, 2003.
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
package com.ibm.lab.soln.jface;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;

import java.util.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class JfacePlugin extends AbstractUIPlugin {
   private final class NamedVisitor implements IResourceProxyVisitor {
      private final String name;
      private NamedVisitor(String name) {
         super();
         this.name = name;
      }
      public boolean visit(IResourceProxy proxy) throws CoreException {
         if (proxy.getName().equals(name)) {
            setFoundResource(proxy.requestResource());
            return false;
         }
         return true;
      }
   }
   private IResource foundResource = null;
   //The shared instance.
   private static JfacePlugin plugin;
   //Resource bundle.
   private ResourceBundle resourceBundle;

   /**
    * The constructor.
    */
   public JfacePlugin(IPluginDescriptor descriptor) {
      super(descriptor);
      plugin = this;
      try {
         resourceBundle =
            ResourceBundle.getBundle("com.ibm.lab.soln.jface.JfacePluginResources");
      } catch (MissingResourceException x) {
         resourceBundle = null;
      }
   }

   /**
    * Returns the shared instance.
    */
   public static JfacePlugin getDefault() {
      return plugin;
   }

   /**
    * Returns the workspace instance.
    */
   public static IWorkspace getWorkspace() {
      return ResourcesPlugin.getWorkspace();
   }

   public IResource findByName(final String name) {
      IProject[] projectList = getWorkspace().getRoot().getProjects();

      IResourceProxyVisitor myVisitor = new NamedVisitor(name);

      for (int i = 0; i < projectList.length; i++) {
         IProject project = projectList[i];
         IResource resource = (IResource) project;
         try {
            resource.accept(myVisitor, IResource.NONE);
            if (getFoundResource() != null) {
               return getFoundResource();
            }
         } catch (CoreException e) {
            // Auto-generated catch block
            e.printStackTrace();
         }
      }
      return getFoundResource();
   }
   /**
    * Returns the string from the plugin's resource bundle,
    * or 'key' if not found.
    */
   public static String getResourceString(String key) {
      ResourceBundle bundle = JfacePlugin.getDefault().getResourceBundle();
      try {
         return bundle.getString(key);
      } catch (MissingResourceException e) {
         return key;
      }
   }

   /**
    * Returns the plugin's resource bundle,
    */
   public ResourceBundle getResourceBundle() {
      return resourceBundle;
   }

   protected void setFoundResource(IResource foundResource) {
      this.foundResource = foundResource;
   }

   protected IResource getFoundResource() {
      return foundResource;
   }
}
