package com.ibm.lab.editor.scanner;
/*
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.jface.text.rules.IWordDetector;

/**
 * A release note aware word detector.
 */
public class ReleaseEditorVOWELWordDetector implements IWordDetector {

   /**
    * @see IWordDetector#isWordIdentifierPart
    */
   public boolean isWordPart(char c) {
      return Character.isLetterOrDigit(c);
   }
   /**
    * @see IWordDetector#isWordIdentifierStart
    */
   public boolean isWordStart(char c) {
      if ((c == 'a')
         || (c == 'e')
         || (c == 'i')
         || (c == 'o')
         || (c == 'u')
         || (c == 'A')
         || (c == 'E')
         || (c == 'I')
         || (c == 'O')
         || (c == 'U'))
         return true;
      else
         return false;
   }
}
