package com.ibm.lab.editor;
/*
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import java.util.ResourceBundle;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.ITextEditorActionDefinitionIds;
import org.eclipse.ui.texteditor.TextEditorAction;


/**
 * Contributes interesting actions to the desktop's Edit menu and
 * the toolbar.
 */
public class ReleaseEditorActionContributor extends BasicTextEditorActionContributor {

	protected RetargetTextEditorAction fContentAssistProposal;
	protected RetargetTextEditorAction fContentAssistTip;
	protected RetargetTextEditorAction fContentFormatProposal;
	protected TextEditorAction fTogglePresentation;

/**
 * Default constructor.
 */
public ReleaseEditorActionContributor() {
	super();

	//ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.lab.editor.ReleaseEditorResources");
	ResourceBundle bundle = EditorPlugin.getDefault().getResourceBundle();

	fContentAssistProposal = new RetargetTextEditorAction(bundle, "ContentAssistProposal.");
	fContentFormatProposal = new RetargetTextEditorAction(bundle, "ContentFormatProposal.");
	fContentAssistTip = new RetargetTextEditorAction(bundle, "ContentAssistTip.");
}
/**
 * @see EditorActionBarContributor#contributeMenu
 */
public void contributeToMenu(IMenuManager mm) {
	IMenuManager editMenu = mm.findMenuUsingPath(IWorkbenchActionConstants.M_EDIT);
	if (editMenu != null) {
		editMenu.add(new Separator());
		editMenu.add(fContentAssistProposal);
		editMenu.add(fContentFormatProposal);
		editMenu.add(fContentAssistTip);
	}
}
	/**
	 * @see EditorActionBarContributor#contributeToToolBar
	 */
	public void contributeToToolBar(IToolBarManager tbm) {
		tbm.add(new Separator());
	}
/**
 * @see EditorActionBarContributor#editorChanged
 */
public void setActiveEditor(IEditorPart part) {

	super.setActiveEditor(part);

	ITextEditor editor = null;
	if (part instanceof ITextEditor)
		editor = (ITextEditor) part;

	fContentAssistProposal.setAction(getAction(editor, "ContentAssistProposal"));
	fContentFormatProposal.setAction(getAction(editor, "ContentFormatProposal"));
	fContentAssistTip.setActionDefinitionId(ITextEditorActionDefinitionIds.CONTENT_ASSIST_CONTEXT_INFORMATION);
	fContentAssistTip.setAction(getAction(editor, "ContentAssistTip"));

}
}
