package com.ibm.lab.soln.editor;

/*
 * Licensed Materials - Property of IBM,
 * WebSphere Studio Workbench
 * (c) Copyright IBM Corp 2000
 */


import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;



/**
 * Example Java completion processor.
 */
public class ReleaseEditorCompletionProcessor implements IContentAssistProcessor {
		
	
	/**
	 * Simple content assist tip closer. The tip is valid in a range
	 * of 5 characters around its popup location.
	 */
	protected static class Validator
		implements IContextInformationValidator, IContextInformationPresenter {

		protected int fInstallOffset;

		/*
		 * @see IContextInformationValidator#isContextInformationValid(int)
		 */
		public boolean isContextInformationValid(int offset) {
			return Math.abs(fInstallOffset - offset) < 5;
		}

		/*
		 * @see IContextInformationValidator#install(IContextInformation, ITextViewer, int)
		 */
		public void install(
			IContextInformation info,
			ITextViewer viewer,
			int offset) {
			fInstallOffset = offset;
		}

		/*
		 * @see org.eclipse.jface.text.contentassist.IContextInformationPresenter#updatePresentation(int, TextPresentation)
		 */
		public boolean updatePresentation(
			int documentPosition,
			TextPresentation presentation) {
			return false;
		}
	};
	
	protected final static String[] fgProposals= {
		"Abstract", "Install", "Error", "Handle", "System", "Requirements" 
	};
	
	protected IContextInformationValidator fValidator= new Validator();
	

/**
 * @see IContentAssistProcessor#computeCompletionProposals(ITextViewer, int)
 */
public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
	ICompletionProposal[] result = new ICompletionProposal[fgProposals.length];
	for (int i = 0; i < fgProposals.length; i++) {
		IContextInformation info = new ContextInformation(fgProposals[i], "'" + fgProposals[i] + "' Release SEF popup");
		result[i] = new CompletionProposal(fgProposals[i], documentOffset, 0, fgProposals[i].length(), null, fgProposals[i], info, "Release notes keyword: '" + fgProposals[i] + "'");
	}
	return result;
}
/**
 * @see IContentAssistProcessor#computeContextInformation(ITextViewer, int)
 */
public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
	IContextInformation[] result = new IContextInformation[5];
	for (int i = 0; i < result.length; i++)
		result[i] = new ContextInformation("proposal " + i + " at position " + documentOffset, "proposal " + i + " valid from " + (documentOffset - 5) + " to " + (documentOffset + 5));
	return result;
}
	/**
	 * @see IContentAssistProcessor#getAutoTipInvocationCharacters()
	 */
	public String getAutoTipInvocationCharacters() {
		return null;
	}
	/**
	 * @see IContentAssistProcessor#getCompletionProposalAutoActivationCharacters()
	 */
	public char[] getCompletionProposalAutoActivationCharacters() {
		return null;
	}
	/**
	 * @see IContentAssistProcessor#getContextInformationAutoActivationCharacters()
	 */
	public char[] getContextInformationAutoActivationCharacters() {
		return null;
	}
/**
 * @see IContentAssistProcessor#getContextInformationValidator()
 */
public IContextInformationValidator getContextInformationValidator() {
	return fValidator;
}
	/**
	 * @see IContentAssistProcessor#getErrorMessage()
	 */
	public String getErrorMessage() {
		return null;
	}
}
