package com.ibm.lab.soln.editor;

import org.eclipse.jface.text.rules.NumberRule;
/*
 * Licensed Materials - Property of IBM,
 * WebSphere Studio Workbench
 * (c) Copyright IBM Corp 2000
 */



import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.*;


/**
 * A Relase Note body scanner.
 */
public class ReleaseEditorBodyScanner extends RuleBasedScanner {
	
	
	private static String[] fgKeywords = { "Abstract", "Install", "Error", "Handle", "System", "Requirements" };
	
	

	
	
/**
 * Creates a Java code scanner
 */
public ReleaseEditorBodyScanner(ReleaseEditorColorProvider provider) {

	IToken keyword = new Token(new TextAttribute(provider.getColor(ReleaseEditorColorProvider.KEYWORD)));
	IToken defaultText = new Token(new TextAttribute(provider.getColor(ReleaseEditorColorProvider.DEFAULT)));
	IToken vowel = new Token(new TextAttribute(provider.getColor(ReleaseEditorColorProvider.VOWEL)));

	List rules = new ArrayList();

	// Add generic number rule.
	rules.add(new NumberRule(defaultText));

	// Add generic whitespace rule.
	rules.add(new WhitespaceRule(new ReleaseEditorWhitespaceDetector()));

	rules.add(new ReleaseEditorVowelRule(new ReleaseEditorVOWELWordDetector(), vowel));

	// Add word rule for keywords, types, and constants.
	WordRule wordRule = new WordRule(new ReleaseEditorWordDetector(), defaultText);
	for (int i = 0; i < fgKeywords.length; i++) {
		wordRule.addWord(fgKeywords[i], keyword);
	}

	rules.add(wordRule);

	IRule[] result = new IRule[rules.size()];
	rules.toArray(result);
	setRules(result);
}
}
