package com.ibm.lab.soln.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
/**
 * Insert the type's description here.
 * Creation date: (2/22/2001 4:04:17 PM)
 * @author: Administrator
 */
import java.util.*;
import org.eclipse.ui.texteditor.*;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.rules.RuleBasedScanner;

public class ReleaseEditor extends AbstractTextEditor {

	private static IDocumentProvider fgDocumentProvider;
	private static ReleaseEditorColorProvider fgColorProvider;
	private static ReleaseEditorBodyScanner fgBodyScanner;

	/**
	 * ReleaseEditor constructor comment.
	 */
	public ReleaseEditor() {
		super();

		fgDocumentProvider = new ReleaseEditorDocumentProvider();
		setSourceViewerConfiguration(
			new ReleaseEditorSourceViewerConfiguration());
		setRangeIndicator(new DefaultRangeIndicator());
		fgColorProvider = new ReleaseEditorColorProvider();
		fgBodyScanner = new ReleaseEditorBodyScanner(fgColorProvider);
	}
	/**
	 * @see AbstractTextEditor#createActions()
	 */
	protected void createActions() {
		super.createActions();

		ResourceBundle bundle = EditorPlugin.getDefault().getResourceBundle();
		setAction(
			"ContentFormatProposal",
			new TextOperationAction(
				bundle,
				"ContentFormatProposal.",
				this,
				ISourceViewer.FORMAT));

		IAction a =
			new TextOperationAction(
				bundle,
				"ContentAssistProposal.",
				this,
				ISourceViewer.CONTENTASSIST_PROPOSALS);
		a.setActionDefinitionId(
			ITextEditorActionDefinitionIds.CONTENT_ASSIST_PROPOSALS);
		setAction("ContentAssistProposal", a);
		a =
			new TextOperationAction(
				bundle,
				"ContentAssistTip.",
				this,
				ISourceViewer.CONTENTASSIST_CONTEXT_INFORMATION);
		a.setActionDefinitionId(
			ITextEditorActionDefinitionIds.CONTENT_ASSIST_CONTEXT_INFORMATION);
		setAction("ContentAssistTip", a);

	}
	/**
	 * @see AbstractTextEditor#editorContextMenuAboutToShow(MenuManager)
	 */
	public void editorContextMenuAboutToShow(IMenuManager menu) {
		super.editorContextMenuAboutToShow(menu);
		addAction(menu, "ContentAssistProposal");
		addAction(menu, "ContentAssistTip");
		addAction(menu, "ContentFormatProposal");
	}

	public static RuleBasedScanner getReleaseSEFBodyScanner() {
		return fgBodyScanner;
	}
	public void dispose() {
		fgColorProvider.dispose();
		super.dispose();
	}
}