package com.ibm.lab.soln.layouts;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

/**
 * Demonstrates the use of all the SWT layout managers
 * and their associated classes. These include:
 * FillLayout, RowLayout, GridLayout, and FormLayout.
 */
public class LayoutView extends ViewPart {
	Button b1;
	Button b2;
	Button b3;
	Button b4;
	Button b5;
	// Name and address fields
	Label firstNameLbl;
	Text firstName;
	Label lastNameLbl;
	Text lastName;
	Label streetLbl;
	Text street;
	Label cityLbl;
	Text city;
	Label stateLbl;
	Combo state;
	static final int line2offset = 30;

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}

	/**
	 * Populate the view with the example layout managers.
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(Composite)
	 */
	public void createPartControl(Composite parent) {
		FillLayout fillLayout = new FillLayout();
		//RowLayout fillLayout = new RowLayout();
		fillLayout.type = SWT.VERTICAL;
		parent.setLayout(fillLayout);

		Group groupFill = new Group(parent, SWT.NONE);
		groupFill.setText("Fill Layout");
		setFillLayout(groupFill);
		Group groupRow = new Group(parent, SWT.NONE);
		groupRow.setText("Row Layout");
		setRowLayout(groupRow);
		Group groupGridButtons = new Group(parent, SWT.NONE);
		groupGridButtons.setText("Grid Layout: Buttons");
		setGridLayoutButtons(groupGridButtons);
		Group groupGridAddress = new Group(parent, SWT.NONE);
		groupGridAddress.setText("Grid Layout: Name and Address Form");
		setGridLayoutAddress(groupGridAddress);
		Group groupFormAddress = new Group(parent, SWT.NONE);
		groupFormAddress.setText("FormLayout: Name and Address Form");
		setFormLayoutAddress(groupFormAddress);
	}

	/**
	 * Define the buttons used by the row and grid layout managers. 
	 * Note: A listener is defined on Button b1 to demonstrate that 
	 * different instances of these buttons are used in more than one layout. 
	 * Widget disposal is not an issue. Even though the same names b1..b5 
	 * are used by each layout manager calling this method, they are separate Button
	 * instances, with separate Composite parent objects. Each parent is reponsible for
	 * disposal of it own children.
	 * @param org.eclipse.swt.widgets.Composite
	 */
	protected void setButtons(Composite parent) {
		final Composite ourParent = parent;
		b1 = new Button(parent, SWT.PUSH);
		b2 = new Button(parent, SWT.PUSH);
		b3 = new Button(parent, SWT.PUSH);
		b4 = new Button(parent, SWT.PUSH);
		b5 = new Button(parent, SWT.PUSH);

		b1.setText("Button 1");
		b1.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				System.out.println(
					"Button b1 pressed. Parent is " + ourParent.toString());
			}
		});
		b2.setText("Button 2");
		b3.setText("Button 3");
		b4.setText("Button 4");
		b5.setText("Button 5");
	}

	/**
	 * Defines a set of checkbox style buttons used by FillLayout. 
	 * @param org.eclipse.swt.widgets.Composite
	 */
	protected void setCheckBoxes(Composite parent) {
		final Composite ourParent = parent;
		b1 = new Button(parent, SWT.CHECK);
		b2 = new Button(parent, SWT.CHECK);
		b3 = new Button(parent, SWT.CHECK);
		b4 = new Button(parent, SWT.CHECK);
		b5 = new Button(parent, SWT.CHECK);
		b1.setText("Checkbox 1");
		b2.setText("Checkbox 2");
		b3.setText("Checkbox 3");
		b4.setText("Checkbox 4");
		b5.setText("Checkbox 5");
	}

	/**
	 * Define the fields used in the grid and form layout examples.
	 * @param org.eclipse.swt.widgets.Composite
	 */
	protected void setFields(Composite group) {
		firstNameLbl = new Label(group, SWT.SINGLE);
		firstName = new Text(group, SWT.SINGLE | SWT.BORDER);
		lastNameLbl = new Label(group, SWT.SINGLE);
		lastName = new Text(group, SWT.SINGLE | SWT.BORDER);
		streetLbl = new Label(group, SWT.SINGLE);
		street = new Text(group, SWT.SINGLE | SWT.BORDER);
		cityLbl = new Label(group, SWT.SINGLE);
		city = new Text(group, SWT.SINGLE | SWT.BORDER);
		stateLbl = new Label(group, SWT.SINGLE);
		state = new Combo(group, SWT.DROP_DOWN | SWT.BORDER | SWT.SIMPLE);
		firstNameLbl.setText("First Name: ");
		lastNameLbl.setText("Last Name: ");
		streetLbl.setText("Street: ");
		cityLbl.setText("City: ");
		stateLbl.setText("State/Province: ");
		state.setItems(new String[] { "AL", "AK", "AZ", "..." });
	}

	/**
	 * Creates a fill layout.
	 * @param org.eclipse.swt.widgets.Composite
	 */
	protected void setFillLayout(Composite parent) {
		//setButtons(parent);
		setCheckBoxes(parent); // alternate controls as checkboxes
		FillLayout fillLayout = new FillLayout();
		fillLayout.type = SWT.VERTICAL;
		parent.setLayout(fillLayout);
	}

	/**
	 * Layout buttons used by the first grid layout example.
	 * @param org.eclipse.swt.widgets.Composite
	 */
	protected void setGridLayoutButtons(Composite parent) {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		setButtons(parent);
		b3.setText("Wider Button 3");
		GridData b5GridData = new GridData();
		b5GridData.horizontalAlignment = GridData.CENTER;
		b5.setLayoutData(b5GridData);
		parent.setLayout(gridLayout);
	}

	/**
	 * Define a name and address form using a grid layout.
	 * @param org.eclipse.swt.widgets.Composite
	 */
	protected void setGridLayoutAddress(Composite parent) {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 4;
		// Layout name and address fields into the grid
		setFields(parent);
		parent.setLayout(gridLayout);
	}

	/**
	 * Create a simple row layout of buttons.
	 * @param org.eclipse.swt.widgets.Composite
	 */
	protected void setRowLayout(Composite parent) {
		setButtons(parent);
		RowLayout rowLayout = new RowLayout();
		rowLayout.wrap = true;
		rowLayout.pack = false;
		rowLayout.justify = true;
		rowLayout.marginLeft = 5;
		rowLayout.marginTop = 5;
		rowLayout.marginRight = 5;
		rowLayout.marginBottom = 5;
		rowLayout.spacing = 10;
		parent.setLayout(rowLayout);
	}

	/**
	 * Define a name and address form using a form layout.
	 * @param Composite
	 */
	protected void setFormLayoutAddress(Composite parent) {
		// Simple name and address input form
		FormLayout addressLayout = new FormLayout();
		addressLayout.marginWidth = 3;
		addressLayout.marginHeight = 3;
		parent.setLayout(addressLayout);
		setFields(parent);
		// FirstName. 5 pixels from top and left edge of group
		FormData firstNameLblFD = new FormData();
		firstNameLblFD.left = new FormAttachment(0, 5);
		firstNameLblFD.top = new FormAttachment(0, 5);
		firstNameLbl.setLayoutData(firstNameLblFD);
		FormData firstNameFD = new FormData();
		// Place first name adjacent its label plux 5 pixels
		firstNameFD.left = new FormAttachment(firstNameLbl, 5);
		// place right edge of text field at 40% of parent width
		firstNameFD.right = new FormAttachment(40, 0);
		firstNameFD.top = new FormAttachment(0, 5);
		firstName.setLayoutData(firstNameFD);
		// Last Name	
		FormData lastNameLblFD = new FormData();
		lastNameLblFD.left = new FormAttachment(firstName, 5);
		lastNameLblFD.top = new FormAttachment(0, 5);
		lastNameLbl.setLayoutData(lastNameLblFD);
		FormData lastNameFD = new FormData();
		lastNameFD.left = new FormAttachment(lastNameLbl, 5);
		// Set right edge at right edge of group less 5 pixels
		lastNameFD.right = new FormAttachment(100, -5);
		lastNameFD.top = new FormAttachment(0, 5);
		lastName.setLayoutData(lastNameFD);
		// Street
		FormData streetLblFD = new FormData();
		streetLblFD.left = new FormAttachment(0, 5);
		// Locate street label vertically relative to previous line
		streetLblFD.top = new FormAttachment(firstNameLbl, line2offset);
		streetLbl.setLayoutData(streetLblFD);
		FormData streetFD = new FormData();
		//line up vertically with firstname
		streetFD.left = new FormAttachment(firstNameLbl, 5);
		streetFD.right = new FormAttachment(lastNameLbl, -5);
		streetFD.top = new FormAttachment(firstNameLbl, line2offset);
		street.setLayoutData(streetFD);
		// City
		FormData cityLblFD = new FormData();
		// Line up vertically with last name 
		cityLblFD.left = new FormAttachment(firstName, 5);
		// Locate street label vertically relative to previous line
		cityLblFD.top = new FormAttachment(firstNameLbl, line2offset);
		cityLbl.setLayoutData(cityLblFD);
		FormData cityFD = new FormData();
		cityFD.left = new FormAttachment(lastNameLbl, 5);
		cityFD.right = new FormAttachment(75, -5);
		cityFD.top = new FormAttachment(firstNameLbl, line2offset);
		city.setLayoutData(cityFD);
		// State
		FormData stateLblFD = new FormData();
		stateLblFD.left = new FormAttachment(city, 5);
		// Locate street label vertically relative to previous line
		stateLblFD.top = new FormAttachment(firstNameLbl, line2offset);
		stateLbl.setLayoutData(stateLblFD);
		FormData stateFD = new FormData();
		stateFD.left = new FormAttachment(stateLbl, 5);
		stateFD.right = new FormAttachment(100, -5);
		stateFD.top = new FormAttachment(firstNameLbl, line2offset);
		state.setLayoutData(stateFD);
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchPart#dispose()
	 */
	public void dispose() {
		super.dispose();
	}
}