/*******************************************************************************
 * Template for lab exercise
 * Copyright (c) 2000, 2003 IBM Corporation.
 *******************************************************************************/
package com.ibm.lab.jface;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * @author PatMc
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class MembersDialog extends Dialog {

	IContainer focusFolder;

	/**
	 * @param parentShell
	 */
	public MembersDialog(Shell parentShell) {
		super(parentShell);
		// Auto-generated constructor stub
	}

	/**
	 * @param shell
	 * @param readmeFolder
	 */
	public MembersDialog(Shell shell, IContainer readmeFolder) {
		this(shell);
		focusFolder = readmeFolder;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent) {
		// Define title
		getShell().setText("JFace Component Dialog");

		// Create layouts required for this dialog
		FillLayout fillLayout = new FillLayout();
		fillLayout.type = SWT.VERTICAL;

		RowLayout rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.justify = true;

		//	Get customized composite from parent and create composite layers
		Composite dialogArea = (Composite) super.createDialogArea(parent);
		dialogArea.setLayout(fillLayout);

		Composite txtArea = new Composite(dialogArea, SWT.BORDER);
		txtArea.setLayout(fillLayout);

		Composite viewerArea = new Composite(dialogArea, SWT.BORDER);
		viewerArea.setLayout(fillLayout);

		// Define labels for display of input and later viewer selection
		Label input = new Label(txtArea, SWT.NONE);
		input.setText(focusFolder.toString());

		final Label selected = new Label(txtArea, SWT.NONE);
		selected.setText("");

		addJFaceViewer(viewerArea, selected);

		return dialogArea;
	}

	/**
	 * @param viewerArea - composite where viewer should be added
	 * @param selected - label that can be used to provide viewer selection feedback
	 */
	private void addJFaceViewer(Composite viewerArea, final Label selected) {
	}

}
