package com.ibm.lab.soln.msseditor.extras;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.text.MessageFormat;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

import com.ibm.lab.soln.msseditor.core.MiniSpreadsheet;
import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetEditor;

/**
 * Action to display the max integer from the mini-spreadsheet.
 */
public class ShowMaxEditorActionDelegate implements IEditorActionDelegate {
	MiniSpreadsheetEditor miniSpreadsheetEditor;
	
	/* non-Javadoc
	 * The constructor.
	 */
	public ShowMaxEditorActionDelegate() {
	}

	/**
	 * Find the largest integer value in the spreadsheet and display its value.
	 * 
	 * @see IEditorActionDelegate#run
	 */
	public void run(IAction action) {
		MiniSpreadsheet mss = miniSpreadsheetEditor.getMiniSpreadsheet();
		int max;

		if (mss.getRowCount() == 0) {
			max = 0;
		} else {
			max = Integer.MIN_VALUE;
			for (int i = 0; i < mss.getRowCount(); i++) {
				for (int j = 0; j < mss.getColumnCount(); j++) {
					max = Math.max(mss.getInt(i, j), max);
				}
			}
		}

		MessageDialog.openInformation(null, "Show Max",
			MessageFormat.format("Max: {0}", new Object[] { Integer.toString(max)}));
	}

	/* non-Javadoc
	 * @see IEditorActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * @see IEditorActionDelegate#setActiveEditor
	 */
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		miniSpreadsheetEditor = (MiniSpreadsheetEditor) targetEditor;
	}
}
