package com.ibm.lab.soln.extensionpoint;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

/** 
 * Creates the menu items for the
 * common tools toolbar pulldown menu.  
 * When an item is selected, it invokes
 * the <code>run()</code> of the corresponding IToolsAction
 * instance specified on the 
 * <code>&lt;tool action=<i>IToolsAction</i> label="xxx"&gt;</code> tag.
 * 
 * @see com.ibm.lab.soln.extensionpoint.ExtensionProcessor
 * @see com.ibm.lab.soln.extensionpoint.IToolAction
 */

public class ToolActionsPulldownDelegate
	implements IWorkbenchWindowPulldownDelegate {
	private ExtensionProcessor extensionProcessor = new ExtensionProcessor();

	public ToolActionsPulldownDelegate() {
		super();
	}

	public void dispose() {
	}

	/**
	 * Returns the menu for this pull down action.  This method will only be
	 * called if the user opens the pull down menu for the action.  The menu
	 * is disposed after use.
	 *
	 * @return the menu
	 */
	public Menu getMenu(Control parent) {
		Menu menu = new Menu(parent);

		// fill the menu with one menu item per toolAction
		for (int i = 0; i < extensionProcessor.getToolActionsParameters().size(); i++) {
			ToolActionParameters extensionParms =
				(ToolActionParameters) extensionProcessor.getToolActionsParameters().get(i);

			MenuItem menuitem = new MenuItem(menu, SWT.NONE);
			menuitem.setText(extensionParms.getActionLabel());

			// save the action in the menu item reference for handling selection
			menuitem.setData(extensionParms.getAction());

			// create and set selection listener with inner class
			menuitem.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					IToolAction action = (IToolAction) e.widget.getData();
					action.run();
				}
			});
		}

		return menu;
	}

	public void init(IWorkbenchWindow window) {
		extensionProcessor.load();
	}
	
	/**
	 * Notifies this action delegate that menu pulldown was selected
	 * (i.e., not one of its menu item choices).
	 */
	public void run(IAction action) {
		MessageDialog.openInformation(
			null,
			"Tool Actions",
			"This menu provides a new extension point that can be filled with tool actions.");
	}
	
	/* non-Javadoc
	 * Notifies this action delegate that the selection in the workbench has changed.
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		// no action needed here
	}
}