package com.ibm.lab.soln.jdt.extras;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.ITerminalSymbols;
import org.eclipse.jface.action.IAction;

public class MakeIMemberPackageAction extends ChangeIMemberFlagAction {

	protected boolean performAction(IAction action, IMember member) {
		deleteFlag(member, Flags.AccPublic, ITerminalSymbols.TokenNamepublic);
		deleteFlag(
			member,
			Flags.AccProtected,
			ITerminalSymbols.TokenNameprotected);
		deleteFlag(member, Flags.AccPrivate, ITerminalSymbols.TokenNameprivate);

		return true;
	}

	protected boolean isChecked(IAction action, IMember member) {
		try {
			int flags = member.getFlags();
			flags &= (Flags.AccPrivate | Flags.AccPublic | Flags.AccProtected);
			return flags == 0;
		} catch (JavaModelException e) {
		}

		return false;
	}
}