package com.ibm.lab.soln.jdt.extras;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.ITerminalSymbols;
import org.eclipse.jface.action.IAction;

/**
 * Action to remove all visibility modifiers from <code>IMember</code>.
 */
public class MakeIMemberDefaultAction extends ChangeIMemberFlagAction {

	/**
	 * @see com.ibm.lab.soln.jdt.extras.ChangeIMemberFlagAction#performAction(IAction, IMember)
	 */
	protected boolean performAction(IAction action, IMember member) {
		deleteFlag(member, Flags.AccPublic, ITerminalSymbols.TokenNamepublic);
		deleteFlag(
			member,
			Flags.AccProtected,
			ITerminalSymbols.TokenNameprotected);
		deleteFlag(member, Flags.AccPrivate, ITerminalSymbols.TokenNameprivate);

		return true;
	}

	/**
	 * @see com.ibm.lab.soln.jdt.extras.ChangeIMemberFlagAction#isChecked(IAction, IMember)
	 */
	protected boolean isChecked(IAction action, IMember member) {
		try {
			int flags = member.getFlags();
			flags &= (Flags.AccPrivate | Flags.AccPublic | Flags.AccProtected);
			return flags == 0;
		} catch (JavaModelException e) {
		}

		return false;
	}
}