package com.ibm.lab.soln.jdt.extras;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.ITerminalSymbols;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * Simple example of <code>IScanner</code> usage.
 * 
 * @see org.eclipse.jdt.core.compiler.IScanner
 */
public class HelloScannerAction implements IWorkbenchWindowActionDelegate {

	private String getExampleSource() {
		String source = 
			"public void reset(float delta) { x = (float) 2.1 + delta; }";
			
//		try {				
//			IProject myProject =
//			  ResourcesPlugin.getWorkspace().
//			      getRoot().getProject("myJavaProject");  
//			IFolder myFolder = myProject.getFolder("mypackage");  
//			IFile myFile = myFolder.getFile("MyClass.java");
//			ICompilationUnit myCU = (ICompilationUnit) JavaCore.create(myFile);
//			IMethod myMethod = myCU.getTypes()[0].getMethods()[0];
//			source = myMethod.getSource();
//		} catch (JavaModelException e) {
//		}
		
		return source;
	}

	/**
	 * Show <code>IScanner</code> output to the Console.
	 * 
	 * @see org.eclipse.jdt.core.compiler.IScanner
	 * @see org.eclipse.jdt.core.compiler.ITerminalSymbols
	 * @see org.eclipse.ui.IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		IScanner scanner =
			ToolFactory.createScanner(false, false, false, false);
		String source = getExampleSource();
		scanner.setSource(source.toCharArray());
		try {
			int token = scanner.getNextToken();
			while (token != ITerminalSymbols.TokenNameEOF) {
				System.out.println(
					"Token("
						+ token + ") = "
						+ ((Scanner) scanner).toStringAction(token));
				token = scanner.getNextToken();
			}
		} catch (InvalidInputException e) {
		}
	}

	/* non-Javadoc
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
	}

	/* non-Javadoc
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
	}

	/* non-Javadoc
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}
}