package com.ibm.lab.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.ui.IActionFilter;

import com.ibm.lab.msseditor.core.MiniSpreadsheetRow;

/**
 * Action filters allows an action delegate to be hidden/disabled without having to
 * create an instance of its target action. This comes in particularly handy when
 * a plug-in extension isn't yet loaded, but its contributed actions must reflect
 * current state.
 * 
 * For an example, see the <code>plugin.xml</code> of 
 * the <code>com.ibm.lab.soln.mini.spreadsheet.extras</code> project, specifically:
 * 
 * <pre>
 * ...
 * &lt;action ...&gt;
 *   &lt;enablement&gt;
 *     &lt;objectState name="hasInts" value="true"/&gt;
 *   &lt;/enablement&gt;
 * &lt;/action&gt;
 * </pre>
 * 
 * Here the enablement of the contributed action is controlled by testing
 * the object state without having to first load the action.
 * 
 * @see com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetUIPlugin#startup()
 */
public class MiniSpreadsheetRowActionFilter implements IActionFilter {

	/**
	 * @see org.eclipse.ui.IActionFilter#testAttribute(Object, String, String)
	 */
	public boolean testAttribute(Object target, String name, String value) {
		if (name.equals("hasInts") && ((MiniSpreadsheetRow) target).hasInts() == 
				Boolean.valueOf(value).booleanValue())
			return true;
		else
			return false;
	}
}
