package com.ibm.lab.msseditor.ui;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;

import com.ibm.lab.msseditor.core.MiniSpreadsheetRow;
import com.ibm.lab.msseditor.ui.actions.MiniSpreadsheetRowActionFilterFactory;

/**
 * The main plugin class to be used in the desktop.
 */
public class MiniSpreadsheetUIPlugin extends AbstractUIPlugin {
	static private MiniSpreadsheetUIPlugin plugin;
	
	/**
	 * Constructor for MiniSpreadsheetUIPlugin.
	 * 
	 * @param descriptor
	 */
	public MiniSpreadsheetUIPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
	}
	
	/**
	 * Return the plug-in ID.
	 */	
	public static String getId() {
		return plugin.getDescriptor().getUniqueIdentifier();
	}
	
	/**
	 * Returns the shared instance.
	 */
	public static MiniSpreadsheetUIPlugin getDefault() {
		return plugin;
	}	

	/**
	 * Register the <code>IActionFilter</code> adapter for <code>MiniSpreadsheetRow</code>.
	 */

	public void startup() throws CoreException {
		super.startup();
	
		Platform.getAdapterManager().registerAdapters(new MiniSpreadsheetRowActionFilterFactory(), MiniSpreadsheetRow.class);
	}

}
