package com.ibm.lab.soln.interopedit.editors;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.Variant;

/**
 * This uses OleAutomation objects o send commands to the Win32 
 * "Shell.Explorer" OLE control. Instances of this class manage 
 * the setup, typical use, and teardown of a simple web browser.
 *
 * 
 * This class wrappers, or is a proxy to, an aggregate of OLE automation objects 
 * contained in the Microsoft Web Browser control.  
 *   
 * Shell.Explorer (OleControSite). The Shdocvw.dll component is more frequently
 * referred as the WebBrowser Control.The WebBrowser control in 
 * turn hosts the MSHTML control (mshtml.dll). Mshtml.dll is the component 
 * that performs the HTML parsing and rendering in Internet Explorer 4.0 and 
 * later. The MSHTML control provides all interfaces for accessing the
 * DOM. The IDispatch interfaces used in this exercise are 
 * the same interfaces used to access the object model by scripts within 
 * web pages. We implement just a small portion of the automation capabilities 
 * of MSHTML here in this excercise. 
 * 
 * The MSHTML control (mshtml.dll) with IE 5.5 and above exposes a automation
 * model that supports most commonly used editing features for both text and 
 * forms. This makes it possible to develop WYSIWYG HTML editing inside an 
 * Eclipse editor. This editor page allows users to enter  * formatted text, 
 * images, etc.
 * 
 * To learn more about MSTHL the DOM and the 
 * editing capabilities, see the MSDN:
 * @link http://msdn.microsoft.com/library/en-us/dnm
 * 
 * The browser object control at:
 * @link http://msdn.microsoft.com/workshop/browser/webbrowser/reference/objects/webbrowser.asp
 *
 * See the Generated .IDL file (by the OLE/COM Object Viewer)
 * typelib filename: mshtml.idl file in the doc folder of this project
 * 
 * 
 */

public class ActiveXWebBrowser {

	//Constants for MSHTML 

	//Element 
	public static final int DISPID_INNERHTML = -2147417086;
	public static final int DISPID_DOCUMENT = 203;
	public static final int DISPID_BODY = 1005;
	public static final int DISPID_ACTIVE_ELEMENT = 1011;
	public static final int DISPID_DOCUMENT_ELEMENT = 1075;

	// Constants for Web Browser ReadyState
	public static final int READYSTATE_UNINITIALIZED = 0;
	public static final int READYSTATE_LOADING = 1;
	public static final int READYSTATE_LOADED = 2;
	public static final int READYSTATE_INTERACTIVE = 3;
	public static final int READYSTATE_COMPLETE = 4;

	// Web Browser properties
	public static final int DISPID_READYSTATE = -525;
	private OleAutomation oleAutomation;
	private OleControlSite controlSite;
	private static ActiveXWebBrowser webBrowser;
	private static OleAutomation document1;
	/**
	 * Creates a Web browser control.
	 * <p>
	 * Typical use:<br>
	 * <code>
	 * OleControlSite oleControlSite = new OleControlSite(oleFrame, style, "Shell.Explorer");<br>
	 * OleAutomation oleAutomation = new OleAutomation(oleControlSite);<br>
	 * OleWebBrowser webBrowser = new OleWebBrowser(oleControlSite, oleAutomation);<br>
	 * </code>
	 * 
	 * @param oleAutomation the OleAutomation object for this control.
	 * @param oleControlSite the OleControlSite object for this control.
	 */
	public ActiveXWebBrowser(
		OleAutomation oleAutomation,
		OleControlSite controlSite) {
		this.oleAutomation = oleAutomation;
		this.controlSite = controlSite;
		webBrowser = this;
	}

	/**
	* Returns the current state of the control.
	* 
	* @return the current state of the control, one of:
	*         READYSTATE_UNINITIALIZED;
	*         READYSTATE_LOADING;
	*         READYSTATE_LOADED;
	*         READYSTATE_INTERACTIVE;
	*         READYSTATE_COMPLETE.
	*/
	public int getReadyState() {
		// dispid=4294966771, type=PROPGET, name="ReadyState"
		int[] rgdispid =
			oleAutomation.getIDsOfNames(new String[] { "ReadyState" });
		int dispIdMember = rgdispid[0];

		Variant pVarResult = oleAutomation.getProperty(dispIdMember);
		if (pVarResult == null)
			return -1;
		return pVarResult.getInt();
	}

	/**
	* Returns the current state of the control.
	* 
	* @return the current state of the control, one of:
	*         READYSTATE_UNINITIALIZED;
	*         READYSTATE_LOADING;
	*         READYSTATE_LOADED;
	*         READYSTATE_INTERACTIVE;
	*         READYSTATE_COMPLETE.
	*/
	public int getDocReadyState() {
		// dispid=4294966771, type=PROPGET, name="ReadyState"
		int[] rgdispid =
			getDocumentAutomation().getIDsOfNames(
				new String[] { "ReadyState" });
		int dispIdMember = rgdispid[0];

		Variant pVarResult = getDocumentAutomation().getProperty(dispIdMember);
		if (pVarResult == null)
			return -1;
		return pVarResult.getInt();
	}

	/**
		 * Navigates to a particular URL.
		 *
		 * @return the platform-defined result code for the "Navigate" method
		 *  invocation
		 */
	public void Navigate(String url) {
		// dispid=104, type=METHOD, name="Navigate"
		int[] rgdispid =
			oleAutomation.getIDsOfNames(new String[] { "Navigate", "URL" });
		int dispIdMember = rgdispid[0];

		Variant[] rgvarg = new Variant[1];
		rgvarg[0] = new Variant(url);
		int[] rgdispidNamedArgs = new int[1];
		rgdispidNamedArgs[0] = rgdispid[1]; // identifier of argument
		Variant pVarResult =
			oleAutomation.invoke(dispIdMember, rgvarg, rgdispidNamedArgs);

	}
	/**
	 * Method gets the document automation object.
	 * @return OleAutomation
	 */
	public OleAutomation getDocumentAutomation() {
		// dispid=203, type=PROPGET, name="Document"
		int[] rgdispid =
			oleAutomation.getIDsOfNames(new String[] { "Document" });
		int dispIdMember = rgdispid[0];
		Variant pVarResult = oleAutomation.getProperty(dispIdMember);
		OleAutomation document = pVarResult.getAutomation();

		if (pVarResult == null) {
			return null;
		} else {
			System.out.println(
				"Get Document Successful : Disp ID" + dispIdMember);

		}

		return document;
	}
	/**
	 * Method docExecCommand.
	 * @param command - see the document exec command identifiers in MSDN
	 * @return int
	 */
	public int docExecCommand(String command) {
		OleAutomation document = getDocumentAutomation();
		int[] rgdispid = document.getIDsOfNames(new String[] { "execCommand" });
		int dispIdMember = rgdispid[0];
		Variant[] rgvarg = new Variant[1]; // this is the parameter
		rgvarg[0] = new Variant(command);
		Variant pVarResult = document.invoke(dispIdMember, rgvarg);

		if (pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}

	/**
	 * Method A helper to dig out the document element
	 * @return OleAutomation
	 */
	public OleAutomation getElementAutomation() {
		OleAutomation document = getDocumentAutomation();
		int[] rgdispid =
			document.getIDsOfNames(new String[] { "documentElement" });
		int dispIdMember = rgdispid[0];
		Variant pVarResult = document.getProperty(dispIdMember);
		OleAutomation element = pVarResult.getAutomation();

		if (pVarResult == null) {
			return null;
		} else {
			System.out.println(
				"Get Element object Successful DispID =  " + dispIdMember);

		}

		return element;

	}
	/**
	 * Method gets all the HTML code in the document
	 * @return String
	 */
	public String getinnerHTML() {
		OleAutomation element = getElementAutomation();
		int[] rgdispid = element.getIDsOfNames(new String[] { "innerHTML" });
		int dispIdMember = rgdispid[0];
		Variant pVarResult = element.getProperty(dispIdMember);

		if (pVarResult == null) {
			return null;
		} else {
			System.out.println(
				"Get innerHTML object Successful DispID: " + dispIdMember);

		}

		return pVarResult.getString();
	}

	/**
	 * Method to Select All editor contents
	 * @param string
	 * @return int
	 */
	public int selectAll() {
		OleAutomation document = getDocumentAutomation();
		int[] rgdispid = document.getIDsOfNames(new String[] { "execCommand" });
		int dispIdMember = rgdispid[0];
		Variant[] rgvarg = new Variant[1]; // this is format parameter
		rgvarg[0] = new Variant("SelectAll");
		Variant pVarResult = document.invoke(dispIdMember, rgvarg);
		if (pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}
	/**
	 * Method to delete/clear the document contents
	 * @param string
	 * @return int
	 */
	public int delete() {
		OleAutomation document = getDocumentAutomation();
		int[] rgdispid = document.getIDsOfNames(new String[] { "execCommand" });
		int dispIdMember = rgdispid[0];
		Variant[] rgvarg = new Variant[1]; // this is format parameter
		rgvarg[0] = new Variant("delete");
		Variant pVarResult = document.invoke(dispIdMember, rgvarg);
		if (pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}
	/**
	 * Method to replace the document contents
	 * @param string - replacement text
	 * @return int 
	 */
	public int replace(String replaceText) {
		OleAutomation document = getDocumentAutomation();
		int[] rgdispid = document.getIDsOfNames(new String[] { "open" });
		int dispIdMember = rgdispid[0];
		Variant[] rgvarg = new Variant[2];
		rgvarg[0] = new Variant("text/html");
		rgvarg[1] = new Variant("replace");
		Variant pVarResult = document.invoke(dispIdMember, rgvarg);
		if (pVarResult == null)
			return 0;

		rgdispid = document.getIDsOfNames(new String[] { "write" });
		dispIdMember = rgdispid[0];
		Variant[] rgvarg2 = new Variant[1];
		rgvarg2[0] = new Variant(replaceText);
		pVarResult = document.invoke(dispIdMember, rgvarg2);
		if (pVarResult == null)
			return 0;

		rgdispid = document.getIDsOfNames(new String[] { "close" });
		dispIdMember = rgdispid[0];
		pVarResult = document.invoke(dispIdMember);

		if (pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}

	/**
	 * Method disposes of the OLE Automation object.
	 */
	public void dispose() {
		if (oleAutomation != null)
			oleAutomation.dispose();
		oleAutomation = null;

	}
	/**
	 * Refreshes the currently viewed page.
	 *
	 * @return the platform-defined result code for the "Refresh" method invocation
	 */
	public void Refresh() {
		// dispid= 4294966746, type=METHOD, name="Refresh"
		int[] rgdispid =
			oleAutomation.getIDsOfNames(new String[] { "Refresh" });
		int dispIdMember = rgdispid[0];

		oleAutomation.invokeNoReply(dispIdMember);
	}

	/**
	 * Returns the webBrowser.
	 * @return ActiveXWebBrowser
	 */
	public static ActiveXWebBrowser getWebBrowser() {
		return webBrowser;
	}

	/**
	 * Method setDesignModePropertyOn. Enables editing inside the IE 
	 * ActiveX control 
	 */
	public boolean setDesignModeProperty(String flag) {
		OleAutomation document = getDocumentAutomation(); // Call Getter Method
		int[] rgdispid = document.getIDsOfNames(new String[] { "designMode" });
		int dispIdMember = rgdispid[0];
		Variant[] rgvarg = new Variant[1];
		rgvarg[0] = new Variant(flag);
		boolean rc = document.setProperty(dispIdMember, rgvarg);
		return rc;

	}

}
