package com.ibm.lab.soln.interopedit.editors;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

import com.ibm.lab.soln.interopedit.ActiveXEditorImages;

/**
 * Manages the installation/deinstallation of global actions for multi-page editors.
 * Responsible for the redirection of global actions to the active editor.
 * Multi-page contributor replaces the contributors for the individual editors in the multi-page editor.
 */
public class ActiveXMultiPageEditorContributor
	extends MultiPageEditorActionBarContributor {

	private Action boldAction;
	private Action italicAction;
	private Action underlineAction;
	private IEditorPart activeEditorPart;

	// Target Editor
	private ActiveXHTMLEditor activeXeditor = null;

	//Target Browser Control
	private ActiveXWebBrowser activeBrowser;

	/**
	 * Creates a multi-page contributor.
	 */
	public ActiveXMultiPageEditorContributor() {
		super();
		createActions();
	}
	/**
	 * Returns the action registered with the given text editor.
	 * @return IAction or null if editor is null.
	 */
	protected IAction getAction(ITextEditor editor, String actionID) {
		return (editor == null ? null : editor.getAction(actionID));
	}
	/**
	 * Sets up the standard (global ) editor menus 
	 * @see org.eclipse.ui.part.MultiPageEditorActionBarContributor#setActivePage(IEditorPart)
	 */

	public void setActivePage(IEditorPart part) {
		if (activeEditorPart == part)
			return;

		activeEditorPart = part;

		IActionBars actionBars = getActionBars();
		if (actionBars != null) {

			ITextEditor editor =
				(part instanceof ITextEditor) ? (ITextEditor) part : null;

			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.DELETE,
				getAction(editor, ITextEditorActionConstants.DELETE));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.UNDO,
				getAction(editor, ITextEditorActionConstants.UNDO));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.REDO,
				getAction(editor, ITextEditorActionConstants.REDO));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.CUT,
				getAction(editor, ITextEditorActionConstants.CUT));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.COPY,
				getAction(editor, ITextEditorActionConstants.COPY));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.PASTE,
				getAction(editor, ITextEditorActionConstants.PASTE));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.SELECT_ALL,
				getAction(editor, ITextEditorActionConstants.SELECT_ALL));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.FIND,
				getAction(editor, ITextEditorActionConstants.FIND));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.BOOKMARK,
				getAction(editor, ITextEditorActionConstants.BOOKMARK));
			actionBars.updateActionBars();
		}

	}
	/**
	 * Method createActions.
	 * Give users access to more editing features by providing menus 
	 * and  toolbar buttons.controls. [Bold, Italic and Underline}
	 * 
	 * Create the handlers that and Fire off Actions contributed by the
	 * ActiveX editor
	 */
	private void createActions() {
		boldAction = new Action() {

			public void run() {
				if (activeXeditor != null) {
					activeBrowser.docExecCommand("Bold");
				}
			}
		};
		
		boldAction.setText("Bold");
		boldAction.setToolTipText("Toggle bold text.");
		boldAction.setImageDescriptor(ActiveXEditorImages.EDITOR_BOLD_IMAGE);
		boldAction.setDisabledImageDescriptor(
			ActiveXEditorImages.EDITOR_BOLD__DISABLED_IMAGE);
		italicAction = new Action() {

			public void run() {
				if (activeXeditor != null) {
					activeBrowser.docExecCommand("Italic");
				}
			}
		};
		italicAction.setText("Italic");
		italicAction.setToolTipText("Toggle Italic Text");
		italicAction.setImageDescriptor(
			ActiveXEditorImages.EDITOR_ITALIC_IMAGE);
		italicAction.setDisabledImageDescriptor(
			ActiveXEditorImages.EDITOR_ITALIC_DISABLED_IMAGE);

		underlineAction = new Action() {

			public void run() {
				if (activeXeditor != null) {
					activeBrowser.docExecCommand("Underline");
				}
			}
		};
		underlineAction.setText("Underline");
		underlineAction.setToolTipText("Toggle Underline TExt");
		underlineAction.setImageDescriptor(
			ActiveXEditorImages.EDITOR_UNDERLINE_IMAGE);
		underlineAction.setDisabledImageDescriptor(
			ActiveXEditorImages.EDITOR_UNDERLINE_DISABLED_IMAGE);

	}
	
	/**
	 * Adds bold, italic and underline actions.

	 * @see org.eclipse.ui.part.EditorActionBarContributor#contributeToMenu(IMenuManager)
	 */
	public void contributeToMenu(IMenuManager manager) { 
		IMenuManager menu = new MenuManager(ActiveXHTMLEditor.EDITOR_LABEL);
		manager.prependToGroup(IWorkbenchActionConstants.MB_ADDITIONS, menu);
		menu.add(boldAction);
		menu.add(italicAction);
		menu.add(underlineAction);

	}
	/**
	 * Adds bold, italic, and underline actions
	 * 
	 * @see org.eclipse.ui.part.EditorActionBarContributor#contributeToToolBar(IToolBarManager)
	 *  */
	public void contributeToToolBar(IToolBarManager manager) {
		manager.add(new Separator());
		manager.add(boldAction);
		manager.add(italicAction);
		manager.add(underlineAction);
	}

	/**
	 * @see org.eclipse.ui.IEditorActionBarContributor#init(IActionBars, IWorkbenchPage)
	 */
	public void init(IActionBars bars, IWorkbenchPage page) {
		super.init(bars, page);
	}

	/**
	 * This method saves the active browser editor the user is working with.

	 * @see org.eclipse.ui.IEditorActionBarContributor#setActiveEditor(IEditorPart)
	 */
	public void setActiveEditor(IEditorPart targetEditor) {
		super.setActiveEditor(targetEditor);
		activeXeditor = null;
		if (targetEditor instanceof ActiveXHTMLEditor)
			activeXeditor = (ActiveXHTMLEditor) targetEditor;
		activeBrowser = activeXeditor.getBrowser();

	}

}