package com.ibm.lab.soln.interopedit.editors;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.swt.*;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.ole.win32.*;
import org.eclipse.swt.widgets.*;

import com.ibm.lab.soln.interopedit.InteropeditPlugin;

/**
 * This class hosts the Shdocvw.dll component. Shdocvw.dll in turn hosts the
 * Mshtml.dll component, as well as any other Active Document component
 * (such as Word, Excel) that can be loaded in place in the browser.  The user 
 * does not use the browser in a way to navigate to a specific document, rather
 * that navigation occurs inside Eclipse when the user opens an *.htm file
 * in their workspace.   
 * 
 */
public class ActiveXBrowserView {

	private Composite displayArea;
	private OleFrame webFrame;
	private ActiveXWebBrowser webBrowser;
	private Text webUrl;
	private OleControlSite webControlSite;
	private boolean activated = false;

	/**
	 * Constructor for ActiveXBrowserView.
	 */
	public ActiveXBrowserView() {
		super();
	}

	/**
	 * Method createBrowserPartControl, used to instantiate the ActiveX
	 * control and automation object.
	 * @param parent
	 * @return ActiveXWebBrowser
	 */
	public ActiveXWebBrowser createBrowserPartControl(Composite parent) {
		displayArea = parent;
		FillLayout fillLayout = new FillLayout();
		displayArea.setLayout(fillLayout);
		createBrowserFrame();
		return createBrowserControl();
	}

	/**
	 * Creates the Web browser OleFrame.
	 */
	private void createBrowserFrame() {
		// Every control must have an associated OleFrame:
		webFrame = new OleFrame(displayArea, SWT.NONE);
		GridData gridData =
			new GridData(GridData.FILL_HORIZONTAL | GridData.FILL_VERTICAL);
		gridData.horizontalSpan = 3;
		webFrame.setLayoutData(gridData);
	}
	/**
	 * Creates Web browser control.
	 */
	private ActiveXWebBrowser createBrowserControl() {
		try {
			// Create an Automation object for access to extended capabilities
			webControlSite =
				new OleControlSite(webFrame, SWT.NONE, "Shell.Explorer");
			OleAutomation oleAutomation = new OleAutomation(webControlSite);
			webBrowser = new ActiveXWebBrowser(oleAutomation, webControlSite);
		} catch (SWTException ex) {
			// Creation may have failed because control is not installed on machine
			Label label = new Label(webFrame, SWT.BORDER);
			InteropeditPlugin.logError("Could Not Create Browser Control", ex);
			label.setText("Could Not Create Browser Control");
			return null;
		}

		addReadyStateListener(webControlSite);

		// in place activate the ActiveX control		
		activated =
			(webControlSite.doVerb(OLE.OLEIVERB_INPLACEACTIVATE) == OLE.S_OK);

		return webBrowser;
	}

	/**
	 * Method addPropertyChangeListener.
	 * @param webControlSite
	 */
	private void addReadyStateListener(OleControlSite webControlSite) {
		// Listen for changes to the ready state and print out the current state 
		webControlSite
			.addPropertyListener(
				ActiveXWebBrowser.DISPID_READYSTATE,
				new OleListener() {
			public void handleEvent(OleEvent event) {
				if (event.detail == OLE.PROPERTY_CHANGING)
					return;
				int state = webBrowser.getReadyState();
				switch (state) {
					case ActiveXWebBrowser.READYSTATE_UNINITIALIZED :
						System.out.println("READYSTATE_UNINITIALIZED");

						break;
					case ActiveXWebBrowser.READYSTATE_LOADING :
						System.out.println("READYSTATE_LOADING");

						break;
					case ActiveXWebBrowser.READYSTATE_LOADED :
						System.out.println("READYSTATE_LOADED");

						break;
					case ActiveXWebBrowser.READYSTATE_INTERACTIVE :
						System.out.println("READYSTATE_INTERACTIVE");

						break;
					case ActiveXWebBrowser.READYSTATE_COMPLETE :
						System.out.println("READYSTATE_COMPLETE");
						break;
				}
			}
		});
	}

	/**
	 * Cleanup method that shuts down and disposes of the ActiveX control
	 */
	public void dispose() {
		if (activated) {
			webControlSite.deactivateInPlaceClient();
			activated = false;
		}
		if (webBrowser != null)
			webBrowser.dispose();
		webBrowser = null;
	}

	/**
	 * Returns the webBrowser.
	 * @return ActiveXWebBrowser
	 */
	public ActiveXWebBrowser getWebBrowser() {
		return webBrowser;
	}

	/**
	 * Returns the webControlSite.
	 * @return OleControlSite
	 */
	public OleControlSite getWebControlSite() {
		return webControlSite;
	}

}
