package com.ibm.lab.soln.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.ibm.lab.soln.msseditor.core.MiniSpreadsheet;
import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetEditor;

/**
 * Common superclass for all mini-spreadsheet editor actions.
 */
public class MiniSpreadsheetEditorAction extends Action {
	public MiniSpreadsheetEditor editor;
	
	public void setActiveEditor(MiniSpreadsheetEditor editor) {
		this.editor = editor;
	}
	
	public MiniSpreadsheet getMiniSpreadsheet() {
		return editor.getMiniSpreadsheet();
	}
	
	public void selectionChanged(IStructuredSelection selection) {}
}
