package com.ibm.lab.soln.msseditor.ui;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.ibm.lab.soln.msseditor.core.MiniSpreadsheetRow;
import com.ibm.lab.soln.msseditor.ui.actions.MiniSpreadsheetRowActionFilterFactory;

/**
 * User interface plug-in for mini-spreadsheet editor.
 */
public class MiniSpreadsheetUIPlugin extends AbstractUIPlugin {
	static private MiniSpreadsheetUIPlugin plugin;
	
	/**
	 * Constructor for MiniSpreadsheetUIPlugin.
	 * 
	 * @param descriptor
	 */
	public MiniSpreadsheetUIPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
	}
	
	/**
	 * Return the plug-in ID.
	 */	
	public static String getId() {
		return plugin.getDescriptor().getUniqueIdentifier();
	}
	
	/**
	 * Returns the shared instance.
	 */
	public static MiniSpreadsheetUIPlugin getDefault() {
		return plugin;
	}	

	/**
	 * Register the <code>IActionFilter</code> adapter for <code>MiniSpreadsheetRow</code>.
	 */
	public void startup() throws CoreException {
		super.startup();
	
		Platform.getAdapterManager().registerAdapters(new MiniSpreadsheetRowActionFilterFactory(), MiniSpreadsheetRow.class);
	}
}