package com.ibm.lab.soln.msseditor.core;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

/**
 * Notification interface between <code>MiniSpreadsheet</code> and their
 * interested parties.
 * 
 * @see MiniSpreadsheet#addMiniSpreadsheetListener(IMiniSpreadsheetListener)
 * @see MiniSpreadsheet#removeMiniSpreadsheetListener(IMiniSpreadsheetListener)
 */
public interface IMiniSpreadsheetListener {
	/**
	 * Notification of a cell modification.
	 * 
	 * @param miniSpreadsheet	changed <code>MiniSpreadsheet</code>
	 * @param row		row index (0-based)
	 * @param column 	column index (0-based)
	 * @param newValue	new string value of changed cell
	 */
	public void valueChanged
		(MiniSpreadsheet miniSpreadsheet, int row, int column, String newValue);
	
	/**
	 * Notification of a rows modification; the change is significant
	 * enough that a delta is not included in the notification, i.e.,
	 * the receiver should assume that all rows may have changed.
	 */
	public void rowsChanged(MiniSpreadsheet miniSpreadsheet);
}
