package com.ibm.lab.soln.dialogs;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * First wizard page in a continuous flow multi-page wizard as implemented by the 
 * <code>StructureWizard</code>. Allows for selection of the next resource creation 
 * page, by type. 
 */
public class StructureInitPage
  extends WizardPage
  implements SelectionListener {

  // switch to control write of trace data
  private boolean traceEnabled = true;

  private Wizard currentWizard;

  private Button folderButton; // folder
  private Button fileButton; // file
  private Button noneButton;
  private IStructuredSelection selection;

  private boolean nextPageExists; // none

  /**
   * Constructor for StructureInitPage.
   * @param pageName
   * @param selection
   */
  public StructureInitPage(
    String pageName,
    IStructuredSelection selection,
    Wizard parent) {
    super(pageName);
    this.selection = selection;
    currentWizard = parent;
    setDescription("Choose the resource creation page you want to see.");
    setTitle("Project Structure Navigation");

  }

  /**
   * Creates the top level dialog control under the given parent composite.
   * <p>
   * Implementors are responsible for ensuring that the created control can 
   * be accessed via <code>getControl</code>. This is done by identifying the main 
   * control you create using the <code>setControl</code> method.
   * </p>
   *
   * @see org.eclipse.jface.dialogs.IDialogPage#createControl(Composite)
   * 
   * @param parent the parent composite
   */
  public void createControl(org.eclipse.swt.widgets.Composite parent) {
    // create a main control, with layout.
    // If layout not provided, page content does not show
    Composite composite = new Composite(parent, SWT.NONE);
    GridLayout compositeLayout = new GridLayout();
    compositeLayout.numColumns = 1;
    compositeLayout.horizontalSpacing = 10;
    compositeLayout.verticalSpacing = 10;
    compositeLayout.marginHeight = 10;
    compositeLayout.marginWidth = 10;
    composite.setLayout(compositeLayout);

    GridData compositeData = new GridData(GridData.FILL_BOTH);
    compositeData.grabExcessHorizontalSpace = true;
    composite.setLayoutData(compositeData);

    // Create radio button group for dynamic page selection
    createNextPageSelection(composite);
    // identify main control for page
    setControl(composite);
  }

  /**
   * Utility method that creates a group with radio buttons that support user 
   * selection of the next create resource wizard page.
   *
   * @param composite  the parent for the new controls
   */
  private Group createNextPageSelection(Composite composite) {

    Group group = new Group(composite, SWT.NONE);
    group.setText("Select the resource type you wish to create:");
    GridData gData = new GridData(GridData.FILL_HORIZONTAL);
    group.setLayoutData(gData);

    GridLayout gLayout = new GridLayout();
    gLayout.numColumns = 1;
    group.setLayout(gLayout);

    // Add Page Control 

    folderButton = createRadioButton(group, "Create a fo&lder");
    fileButton = createRadioButton(group, "Create a f&ile");
    //    noneButton =
    //      createRadioButton(
    //        group,
    //        "Skip resource creation");

    return group;
  }

  /**
   * Utility method that creates a radio button instance
   * and sets the default layout data.
   *
   * @param parent  the parent for the new button
   * @param label  the label for the new button
   * @return the newly-created button
   */
  private Button createRadioButton(Composite parent, String label) {
    Button button = new Button(parent, SWT.RADIO | SWT.LEFT);
    button.setText(label);
    //	button.addListener(SWT.Selection, this);
    GridData data = new GridData(GridData.FILL_HORIZONTAL);
    button.setLayoutData(data);
    button.addSelectionListener(this);
    return button;
  }

  /* non-Javadoc
   * 
   * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(SelectionEvent)
   */
  public void widgetDefaultSelected(SelectionEvent e) {
  }

  /**
   * Event logic for radio button group. Identifies if another page has been
   * selected so that the next button can be enabled.
   * 
   * @see org.eclipse.swt.events.SelectionListener#widgetSelected(SelectionEvent)
   */
  public void widgetSelected(SelectionEvent e) {
    if (folderButton.getSelection()) {
      //         currentWizard.addPage(n);
      System.out.println("new folder request");
      nextPageExists = true;
    } else {
      if (fileButton.getSelection()) {
        System.out.println("new file request");
        nextPageExists = true;
      }
    }
    getWizard().getContainer().updateButtons();

  }

  /**
   * Provides a next page based on the current selection.
   * If a page has been requested it is added to the wizard first.
   * 
   * The inherited <code>getNextPage</code>framework method is used to 
   * return the next page which was just added.
   * 
   * @see org.eclipse.jface.wizard.IWizardPage#getNextPage()
   */
  public IWizardPage getNextPage() {
    // add and then return folder page if requested
    if (folderButton.getSelection()) {
      currentWizard.addPage(
        new StructureNewFolderWizardPage("fold", selection, currentWizard));
      return super.getNextPage();
    } else {
      // add and then return file page if requested
      if (fileButton.getSelection()) {
        currentWizard.addPage(
          new StructureNewFileWizardPage("file", selection, currentWizard));
        return super.getNextPage();
      }
    }
    return null;
  }

  /**
   * If another page exists the Next button will be enabled.
   * This decision controlled by the <code>widgetSelected</code> event logic 
   * for the radio button group.
   * 
   * @see org.eclipse.jface.wizard.IWizardPage#canFlipToNextPage()
   */
  public boolean canFlipToNextPage() {
    return nextPageExists;
  }

  /**
   * Write trace statements.  
   * System.out.println with prefix tagging used for simplicity.
   */
  private void traceMsg(String msg) {
    if (IDialogsIDs.TRACE_ENABLED | traceEnabled)
      System.out.println(msg);
  }

}