package com.ibm.lab.soln.dialogs;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
 
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * Example of how a preference page can be constructed using the approach supported 
 * by the <code>FieldEditorPreferencePage</code> superclass.  User interface controls
 * are defined using specific <code>FieldEditor</code> types.  The 
 * <code>FieldEditorPreferencePage</code> superclass automates preference store 
 * interaction.
 * 
 */
public class MyPrefPageFieldEditor
   extends FieldEditorPreferencePage
   implements IWorkbenchPreferencePage {

   /**
    * Constructor for MyPrefPageFieldEditor.
    * @param style
    */
   protected MyPrefPageFieldEditor(int style) {
      super(style);
   }

   /**
    * Constructor for MyPrefPageFieldEditor.
    * @param title
    * @param style
    */
   protected MyPrefPageFieldEditor(String title, int style) {
      super(title, style);
   }

   /**
    * Constructor for MyPrefPageFieldEditor.
    * @param title
    * @param image
    * @param style
    */
   protected MyPrefPageFieldEditor(
      String title,
      ImageDescriptor image,
      int style) {
      super(title, image, style);
   }

   public MyPrefPageFieldEditor() {
      super(GRID);
      setDescription("My Field Editor Preference Page \n");
      IPreferenceStore store = DialogsPlugin.getDefault().getPreferenceStore();
      setPreferenceStore(store);
   }
   /**
    * Adds field editors used to implement the user interface.  Each editor is 
    * added with string values for the preference key and lab used for the widget
    * added to the user interface.
    * 
    * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
    */
   protected void createFieldEditors() {
      ColorFieldEditor colorField =
         new ColorFieldEditor(
            "COLOR_KEY",
            "COLOR_KEY_Label",
            getFieldEditorParent());

      BooleanFieldEditor choiceField =
         new BooleanFieldEditor(
            "BOOLEAN_KEY",
            "BOOLEAN_KEY_Label",
            org.eclipse.swt.SWT.NONE,
            getFieldEditorParent());

      FileFieldEditor fileField =
         new FileFieldEditor(
            "FILE_KEY",
            "FILE_KEY_Label",
            true,
            getFieldEditorParent());
      fileField.setFileExtensions(new String[] { "*.jar", "*.txt", "*.zip" });

      DirectoryFieldEditor dirField =
         new DirectoryFieldEditor(
            "DIR_KEY",
            "DIR_KEY_Label",
            getFieldEditorParent());

      addField(colorField);
      addField(choiceField);
      addField(fileField);
      addField(dirField);
   }

   /* non-Javadoc
    * 
    * Not used in this example, implemented per the interface.
    * Setting the active preference store for this page could be done here, but 
    * is done in the constructor in this example.
    * 
    * @see org.eclipse.ui.IWorkbenchPreferencePage#init(IWorkbench)
    */
   public void init(IWorkbench workbench) {
   }
}