package com.ibm.lab.soln.dialogs;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
 
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * Customized version of the <code>WizardNewFileCreationPage</code>. Adds finish 
 * processing and support for custom file content.
 */
public class MyNewFileWizardPage extends WizardNewFileCreationPage {

   /**
    * Constructor for MyNewFileWizardPage.
    * @param pageName
    * @param selection
    */
   public MyNewFileWizardPage(
      String pageName,
      IStructuredSelection selection) {
      super(pageName, selection);
   }

   /**
    * Processes the create new file request by calling methods inherited from
    * the <code>MyNewFileWizardPage</code> superclass.  
    * 
    * @see org.eclipse.ui.dialogs.WizardNewFileCreationPage#createNewFile
    * 
    * @return boolean - indicates if the file was created.
    */
   public boolean finish() {
      // create the new file resource
      IFile newFile = createNewFile();
      if (newFile == null)
         return false; //creation was unsuccessful
      return true;
   }

   /**
    * Customized method that provides simple content for the file being created.
    * 
    * @see org.eclipse.ui.dialogs.WizardNewFileCreationPage#getInitialContents()
    */
   protected InputStream getInitialContents() {
      StringBuffer sb = new StringBuffer();
      sb.append("My New File Contents");

      return new ByteArrayInputStream(sb.toString().getBytes());
   }

}