package com.ibm.lab.soln.dialogs;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
 
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * Demonstration of a simple multi-page wizard that supports controlled paging and file creation.
 * 
 * Three pages are added in the addPages() method.
 * 
 * File creation is supported through a custom page that inherits 
 * container selection and file name validation.
 * 
 * Additional pages support testing of the page complete status using values 
 * passed to the wizard page constructors.
 * 
 * @see org.eclipse.jface.wizard.Wizard
 * @see org.eclipse.ui.INewWizard
 */
public class MyBasicWizard extends Wizard implements INewWizard {
   // switch to control write of trace data
   private boolean traceEnabled = false;

   // to hold selected project resource for run method access
   public IStructuredSelection selection;

   //   private org.eclipse.ui.IWorkbench myWorkbench;
   // field wizard page to support references in wizard logic
   private MyNewFileWizardPage myNewPage;

   /**
    * The constructor.
    */
   public MyBasicWizard() {
   }

   /**
    * Passes the wizard finish request on to the new file page.
    * The new file page is the only page in this wizard that has finish
    * processing to implement.
    * 
    * @see org.eclipse.jface.wizard.IWizard#performFinish()
    */
   public boolean performFinish() {

      return myNewPage.finish();
   }

   /**
    * Initialize processing saves local workbench and 
    * selection references and sets wizard title/image.
    * 
    * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
    */
   public void init(IWorkbench workbench, IStructuredSelection selection) {

      // tracing output
      traceMsg("MBWizard: ----> Start Wizard");
      traceMsg("MBWizard: -------> in method init.");

      // Wizard customization
      setWindowTitle("Customized Wizard Title");
      setDefaultPageImageDescriptor(getImageDescriptor("eclipse.jpg"));

      // Saving local references to the workbench and resource selected in navigator
      this.selection = selection;
      //      this.myWorkbench = workbench;

   }

   /**
    * Utility method that returns a named image from the plugin icons directory.
    * 
    * @param relativePath  name or directory/name of the image requested
    * @return  an ImageDescriptor for the identified image if found at the path
    */
   private ImageDescriptor getImageDescriptor(String relativePath) {
      String iconPath = "icons/";
      try {
         DialogsPlugin plugin = DialogsPlugin.getDefault();
         URL installURL = plugin.getDescriptor().getInstallURL();
         URL url = new URL(installURL, iconPath + relativePath);
         return ImageDescriptor.createFromURL(url);
      } catch (MalformedURLException e) {
         // Should not happen
         return null;
      }
   }

   /**
    * Add predetermined pages that are required in the wizard.
    * Other pages could be added after the wizard starts using the addPage() method.
    * 
    * @see org.eclipse.jface.wizard.Wizard#addPages()
    */
   public void addPages() {
      // Add customized new file wizard page - set title and description attributes
      myNewPage = new MyNewFileWizardPage("New File", selection);
      addPage(myNewPage);
      myNewPage.setTitle("My New File Page Title");
      myNewPage.setDescription("My New File Page Description");

      // Add pages to the wizard page sequence
      // Constructor logic defined page title and 
      addPage(
         new MyBasicWizardPage1("Page1", "My First Wizard Page", null, false));
      addPage(
         new MyBasicWizardPage2("Page2", "My Second Wizard Page", null, false));

   }

   /**
    * Write trace statements.  
    * System.out.println used for simplicity.
    */
   void traceMsg(String msg) {
      if (IDialogsIDs.TRACE_ENABLED | traceEnabled)
         System.out.println(msg);
   }
}