package com.ibm.lab.soln.dialogs;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.core.runtime.QualifiedName;

/**
 * Definition of common key and string values that are used in the 
 * <code>com.ibm.lab.soln.dialogs</code> plug-in.
 */
public interface IDialogsIDs {

  /** Global Trace Control */
  public final boolean TRACE_ENABLED = true;

  /** Key for string value to be stored as a resource property */
  public static QualifiedName PROP_NAME_KEY =
    new QualifiedName("com.ibm.lab.soln.dialogs", "My_Prop_Name");

  /** Key for boolean value to be stored as a resource property.
    * Used by the com.ibm.lab.soln.resources plugin if available.
    * If the value changes here, it must also change in the IResourceIDs interface.
    */
  public static QualifiedName REDIT_PROPERTY_KEY =
    new QualifiedName("com.ibm.lab.soln.dialogs", "Recent_Edits");

  /** key for string value to be stored as a resource property */
  public static String TEXT_PREFERENCES_KEY = "text_field_key";

  /** Key for boolean value to be stored as a resource property.
    * Used by the com.ibm.lab.soln.resources plugin if available.
    * If the value changes here, it must also change in the IResourceIDs interface.
    */
  public static String REDIT_PREFERENCES_KEY = "Recent_Edits_Limit";

  /** Key for boolean value to be stored as a resource property.
    * Used by the com.ibm.lab.soln.resources plugin if available.
    * If the value changes here, it must also change in the IResourceIDs interface.
    */
  public static String REDIT_PREFERENCES_KEY2 = "Recent_Edits_Persistence";

  /** Key for boolean value to be stored as a resource property.
    * Used by the com.ibm.lab.soln.resources plugin if available.
    */
  public static int REDIT_PREFERENCES_DEFAULT = 8;

  /** Options for the resource property user interface.
    * Used by the com.ibm.lab.soln.resources plugin if available.
    */
  public String[] REDIT_OPTIONS = { "4", "8", "12" };

}
