package com.ibm.lab.soln.dialogs;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionDelegate;

/**
 * Example of using the <code>IDialogSettings</code> API to put values into
 * plug-in specific storage.
 */
public class DialogSettingsAction implements IActionDelegate {

  /**
   * Gets the plug-in's <code>IDialogSettings</code>, creates a section, and
   * uses <code>put()</code> logic to save values for each supported data type.
   */
  public void run(IAction action) {

    IDialogSettings dset = DialogsPlugin.getDefault().getDialogSettings();

    int inum = 1;
    double dnum = 2000000000;
    long lnum = 300000000;
    float fnum = 400000000;

    boolean trueFalse = false;

    String localKey = "myValue";
    String[] sList = { "a", "b", "c" };

    IDialogSettings dsetSection = dset.addNewSection("MyValuesSection");
    dsetSection.put("int", inum);
    dsetSection.put("double", dnum);
    dsetSection.put("long", lnum);
    dsetSection.put("float", fnum);
    dsetSection.put("trueFalse", false);
    dsetSection.put("string", "myValue");
    dsetSection.put("stringArray", sList);
  }

  /* non-Javadoc
   * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
   */
  public void selectionChanged(IAction action, ISelection selection) {
  }

}
