package com.ibm.lab.soln.newWizard;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.ibm.lab.soln.newWizard.rcl.ResourceChangeReporter;

/**
 * The main plugin class to be used in the desktop.
 */
public class NewWizardPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static NewWizardPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;

	/**
	 * The constructor.
	 */
	public NewWizardPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle =
				ResourceBundle.getBundle(
					"com.ibm.lab.newWizard.NewWizardPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static NewWizardPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = NewWizardPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#startup()
	 */
	public void startup() throws CoreException {
		// Let super do the normal startup work
		super.startup();
		// The resource change listener will be added if/when this method is invoked
		addRCL();
	}

	/**
	 * Adds a workspace resource change listener when called 
	 * by the <code>ActionManageTraceRCLs</code> logic.
	 * 
	 * Multiple approaches to adding an RCL, with all or selected event types 
	 * identified, are included in the method source.
	 */
	public void addRCL() throws CoreException {

		// create listener and add to workspace for all event types
		ResourceChangeReporter myListener = new ResourceChangeReporter();

		getWorkspace().addResourceChangeListener(
			myListener,
			IResourceChangeEvent.POST_CHANGE);

	}
}
