package com.ibm.lab.soln.newWizard;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/**
 * Edu-Sol: 01 - New resource wizards implement INewWizard
 * @see Wizard
 */
public class CustomProjectWizard extends Wizard implements INewWizard {
	private CustomWizardNewProjectCreationPage projectPage;

	private CustomProjectFilePage filePage;

	//	private IProject newProject;

	/**
	 * 
	 */
	public CustomProjectWizard() {
	}

	/**
	 * @see Wizard#performFinish
	 */
	public boolean performFinish() {

		// Get project from projectPage
		final IProject newProject = projectPage.getProjectHandle();
		
		//		Get project location as required
		final IPath projectLoc = getProjectLocation();

		// Identify choices made on the filePage
		final boolean needsCustomized = projectPage.needfilePage.getSelection();
		final boolean log = filePage.loggingFile.getSelection();
		final boolean readme = filePage.readmeFile.getSelection();

		WorkspaceModifyOperation op = new WorkspaceModifyOperation() {
			protected void execute(IProgressMonitor monitor)
				throws CoreException, InvocationTargetException, InterruptedException {

				monitor.beginTask("Create Customized Project:", 3000);
				monitor.subTask("prepare");

				monitor.worked(1000);
				ProjectCustomizer.pause(1000);

				// Create project using custom location if provided
				createProject(
					newProject,
					projectLoc,
					new SubProgressMonitor(monitor, 1000));

				// If project exists, customize it
				if (newProject.exists() && needsCustomized) {
					monitor.subTask("customize");
					ProjectCustomizer.pause(1000);

					customizeProject(
						newProject,
						log,
						readme,
						new SubProgressMonitor(monitor, 1000));
				}

				monitor.done();
			}
		};

		try {
			getContainer().run(true, false, op);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		//		If project exists, return true, if not return false 
		if (newProject.exists())
			return true;
		else
			return false;

	}

	private IPath getProjectLocation() {

		IPath projectLoc = null;
		if (!projectPage.useDefaults())
			projectLoc = projectPage.getLocationPath();
		return projectLoc;
	}

	/**
	 * @param newProject
	 */
	private void createProject(
		IProject newProject,
		IPath projectLoc,
		IProgressMonitor monitor) {

		monitor.beginTask("", 500);
		monitor.subTask("create project description");
		// Create project description
		IProjectDescription projectDesc =
			NewWizardPlugin.getWorkspace().newProjectDescription(newProject.getName());

		projectDesc.setLocation(projectLoc);
		monitor.worked(100);
		ProjectCustomizer.pause(1000);

		// Create project

		try {
			monitor.subTask("create project");
			newProject.create(projectDesc, monitor);
			monitor.worked(100);
			ProjectCustomizer.pause(1000);

			monitor.subTask("open the new project");
			newProject.open(monitor);
			monitor.worked(100);
			ProjectCustomizer.pause(1000);

			monitor.done();

		} catch (CoreException e) {
			// Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * @param log
	 * @param readme
	 */
	private void customizeProject(
		IProject project,
		boolean log,
		boolean readme,
		IProgressMonitor monitor) {

		monitor.beginTask("", 3000);

		// Create Folder
		monitor.subTask("add folder");
		IFolder readmeFolder = ProjectCustomizer.createFolder(project, "readme");

		monitor.worked(1000);
		ProjectCustomizer.pause(1000);

		// Create Logging File (if required)
		monitor.subTask("add log file");
		if (log)
			ProjectCustomizer.createChangeLogFile(project, "Change_log.txt");

		monitor.worked(1000);
		ProjectCustomizer.pause(1000);

		//	Create Readme File from template (if required)
		monitor.subTask("add readme file");
		if (readme) {
			IPath template = new Path("readme_template/readme_file_template.readme");
			String fileName = project.getName() + ".readme";
			ProjectCustomizer.copyTemplate(readmeFolder, fileName, template);
		}

		monitor.worked(1000);
		ProjectCustomizer.pause(1000);

		monitor.done();
	}

	/* 
	 * Edu-Sol: 03 - Add wizard page(set to false) after new project wizard pages 
	 * (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages() {
		projectPage = new CustomWizardNewProjectCreationPage("projectPage");
		projectPage.setTitle("Create a New Project");
		projectPage.setDescription(
			"Enter name and optional custom location for a project");
		addPage(projectPage);

		filePage =
			new CustomProjectFilePage("filePage", "Generated Project Files", null);
		filePage.setDescription("Select the files to be added to the project.");
		filePage.setPageComplete(false);
		addPage(filePage);
	}

	/**
	 * Edu-Sol: 02 - Let New Project Wizard initialize itself 
	 * @see Wizard#init
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		//		super.init(workbench, selection);
		setWindowTitle("Create New Custom Project");
		setNeedsProgressMonitor(true);
	}

	public CustomProjectFilePage getFilePage() {
		return filePage;
	}
}
