package com.ibm.lab.soln.serviceableplugin.extras;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import java.util.*;

/**
 * The main plugin class used in the service example.
 */
public class ServiceablePlugin extends AbstractUIPlugin {
	//The shared instance.
	private static ServiceablePlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;

	/**
	 * The constructor.
	 */
	public ServiceablePlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle =
				ResourceBundle.getBundle(
					"com.ibm.lab.soln.extras.serviceableplugin.FirstpluginPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}

	}

	/**
	 * Returns the shared instance of this plug-in.
	 */
	public static ServiceablePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = ServiceablePlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	/**
	 * Returns the plugin's product vital data. the vitalInfoStatus method 
	 * creates a Status object for the provider name, plug-in name, plug-in id,
	 *  and version. Each Status object is added to the MultiStatus object.  
	 */

	public MultiStatus getServiceInfo(CoreException exception) {
		MultiStatus vitalInfoStatus =
			new MultiStatus(
				getDescriptor().getUniqueIdentifier(),
				exception.getStatus().getSeverity(),
				exception.getMessage(),
				exception);
		// Put the information into their own status containers because this 
		// forces new lines in the details section of the ErrorDialog 
		
		// Provider name
		vitalInfoStatus.add(
			createStatus(
				exception.getStatus().getSeverity(),
				"Plug-in Provider:.... " + getDescriptor().getProviderName()));
				
		// Plug-in name (user friendly name)
		vitalInfoStatus.add(
			createStatus(
				exception.getStatus().getSeverity(),
				"Plug-in Name:....... " + getDescriptor().getLabel()));

		// Plug-in ID
		vitalInfoStatus.add(
			createStatus(
				exception.getStatus().getSeverity(),
				"Plug-in ID:........... "  + getDescriptor().getUniqueIdentifier()));

		// Version
		vitalInfoStatus.add(
			createStatus(
				exception.getStatus().getSeverity(),
				"Version:.............. " + getDescriptor().getVersionIdentifier().toString()));

		return vitalInfoStatus;
	}

	/**
	 * Method createStatus is helper method that creates a Status object.
	 * @param int severity code
	 * @param String status message
	
	 */
	protected Status createStatus(int severity, String msg) {
		Status status =
			new Status(
				severity,
				getDescriptor().getUniqueIdentifier(),
				IStatus.OK,
				msg,
				null);
		return status;

	}
}