package com.ibm.lab.soln.serviceableplugin.extras;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * An exception class used in the service example. 
 */
public class ServiceException extends CoreException {

	/**
	 * Constructor for ServiceException.
	*/
	public ServiceException(String msg) {
		super(new Status(
				IStatus.ERROR,
				ServiceablePlugin.getDefault().getDescriptor().getUniqueIdentifier(),
				IStatus.OK,
				msg,
				null));
	}

}