package com.ibm.lab.dialogs;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * A simple Wizard Page provided for use as-is during the exercise.
 */
public class MyBasicWizardPage2 extends WizardPage {
   // Status indicator field used to track and display page status value
   String pageControlStatus = null;
   // Label used to display page status   
   Label statusLabel = null;
   public MyBasicWizardPage2(String pageName) {
      super(pageName);
   }
   /**
    * Constructor to set default page status field text.
    */
   public MyBasicWizardPage2(
      String pageName,
      String title,
      org.eclipse.jface.resource.ImageDescriptor titleImage) {
      super(pageName, title, titleImage);
      pageControlStatus = "Page complete status defaults to true";

   }
   /**
    * Constructor to initialize page status field and set page status field text.
    */
   public MyBasicWizardPage2(
      String pageName,
      String title,
      org.eclipse.jface.resource.ImageDescriptor titleImage,
      boolean pageStatus) {
      //
      this(pageName, title, titleImage);
      setPageComplete(pageStatus);
      pageControlStatus =
         "Page complete status of "
            + pageStatus
            + " set in constructor for page";
   }
   /**
    * Constructor that prefixes passed title value with string "Title: ".
    */
   public MyBasicWizardPage2(String name, boolean pageStatus) {
      super(name);
      this.setTitle("Title: " + name);
      setPageComplete(pageStatus);
   }
   /**
    * Creates the top level dialog control under the given parent composite.
    * <p>
    * Implementors are responsible for ensuring that
    * the created control can be accessed via <code>getControl</code>
    * </p>
    *
    * @param parent the parent composite
    */
   public void createControl(org.eclipse.swt.widgets.Composite parent) {

      Group optGroup = createGroup(parent, "Group Text");
      createLabel(optGroup, "QRS: Basic Wizard Page Two.");
      statusLabel = createLabel(optGroup, pageControlStatus);

      createText(optGroup, "Text Value");
      createRadioButton(optGroup, "RButton1 Text");
      createRadioButton(optGroup, "RButton2 Text");

      setControl(optGroup);
   }
   /**
    * Utility method that creates a group instance
    * and sets the default layout data.
    *
    * @param parent  the parent for the new group
    * @param text  the text for the new group
    * @return the new group
    */
   private Group createGroup(Composite parent, String text) {
      Group group = new Group(parent, SWT.NONE);
      //	group.setSize(50, 40);
      group.setLayout(new GridLayout());
      group.setText(text);
      //	group.setLayoutData(
      //		new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));

      GridData data = new GridData(GridData.FILL_HORIZONTAL);
      //	data.horizontalSpan = 2;
      //	data.horizontalAlignment = GridData.FILL;
      group.setLayoutData(data);
      return group;
   }
   /**
    * Utility method that creates a label instance
    * and sets the default layout data.
    *
    * @param parent  the parent for the new label
    * @param text  the text for the new label
    * @return the new label
    */
   private Label createLabel(Composite parent, String text) {
      Label label = new Label(parent, SWT.LEFT);
      label.setText(text);
      //	GridData data = new GridData(GridData.FILL_HORIZONTAL);;
      GridData data = new GridData(GridData.FILL_BOTH);
      ;
      //	data.horizontalSpan = 2;
      //	data.horizontalAlignment = GridData.FILL;
      label.setLayoutData(data);
      return label;
   }
   /**
    * Utility method that creates a radio button instance
    * and sets the default layout data.
    *
    * @param parent  the parent for the new button
    * @param label  the label for the new button
    * @return the newly-created button
    */
   private Button createRadioButton(Composite parent, String label) {
      Button button = new Button(parent, SWT.RADIO | SWT.LEFT);
      button.setText(label);
      //	button.addListener(SWT.Selection, this);
      GridData data = new GridData(GridData.FILL_HORIZONTAL);
      button.setLayoutData(data);
      return button;
   }
   /**
    * Utility method that creates a text widget instance
    * and sets the default layout data.
    *
    * @param parent  the parent for the new text widget
    * @param text  the text for the new text widget
    * @return the new text widget
    */
   private Text createText(Composite parent, String text) {
      Text textInfo = new Text(parent, SWT.SINGLE | SWT.BORDER);
      textInfo.setText(text);
      GridData data = new GridData(GridData.FILL_HORIZONTAL);
      textInfo.setLayoutData(data);
      return textInfo;
   }
   /**
    * Override of Wizardpage method to demonstrate timing of page state change.
    * 
    * @param visible  boolean that identifies page as either gaining or loosing focus.
    */
   public void setVisible(boolean visible) {
      super.setVisible(visible);

      /*		System.out.println(
      			"MBWizardPage: ----> setVisible("
      				+ visible
      				+ ")"
      				+ "for page: "
      				+ this.getName());
      // Only changes the state to true if the page was false
      if (!this.isPageComplete()) {
         setPageComplete(true);
         statusLabel.setText(
            statusLabel.getText()
               + "\n"
               + "Page complete status set "
               + "by setVisible() method to true");
      } */
   }
}