package com.ibm.lab.interopedit.editors;

/*
 * (c) Copyright IBM Corp. 2000, 2002.
 * All Rights Reserved.
 */

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;


/**
 * @author scottf
 *
 * Manages the installation/deinstallation of global actions for multi-page editors.
 * Responsible for the redirection of global actions to the active editor.
 * Multi-page contributor replaces the contributors for the individual editors in the multi-page editor.
 */
public class ActiveXMultiPageEditorContributor
	extends MultiPageEditorActionBarContributor {

	private Action boldAction;
	private Action italicAction;
	private Action underlineAction;
	private IEditorPart activeEditorPart;

	// Target Editor
	private ActiveXHTMLEditor activeXeditor = null;

	//Target Browser Control
	private ActiveXWebBrowser activeBrowser;

	/**
	 * Creates a multi-page contributor.
	 */
	public ActiveXMultiPageEditorContributor() {
		super();
		createActions();
	}
	/**
	 * Returns the action registed with the given text editor.
	 * @return IAction or null if editor is null.
	 */
	protected IAction getAction(ITextEditor editor, String actionID) {
		return (editor == null ? null : editor.getAction(actionID));
	}
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorActionBarContributor#setActivePage(IEditorPart)
	 */

	public void setActivePage(IEditorPart part) {
		if (activeEditorPart == part)
			return;

		activeEditorPart = part;

		IActionBars actionBars = getActionBars();
		if (actionBars != null) {

			ITextEditor editor =
				(part instanceof ITextEditor) ? (ITextEditor) part : null;

			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.DELETE,
				getAction(editor, ITextEditorActionConstants.DELETE));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.UNDO,
				getAction(editor, ITextEditorActionConstants.UNDO));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.REDO,
				getAction(editor, ITextEditorActionConstants.REDO));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.CUT,
				getAction(editor, ITextEditorActionConstants.CUT));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.COPY,
				getAction(editor, ITextEditorActionConstants.COPY));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.PASTE,
				getAction(editor, ITextEditorActionConstants.PASTE));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.SELECT_ALL,
				getAction(editor, ITextEditorActionConstants.SELECT_ALL));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.FIND,
				getAction(editor, ITextEditorActionConstants.FIND));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.BOOKMARK,
				getAction(editor, ITextEditorActionConstants.BOOKMARK));
			actionBars.updateActionBars();
		}

	}
	/**
	 * Method createActions.
	 * Give users access to more editing features by providing menus 
	 * and  toolbar buttons.controls. [Bold, Italic and Underline}
	 * 
	 * Create the handlers that and Fire off Actions contributed by the
	 * ActiveX editor
	 */
	private void createActions() {

	}
	
	/**
	 * @see org.eclipse.ui.part.EditorActionBarContributor#contributeToMenu(IMenuManager)
	 * Add bold, italic and underline actions
	 */


	/**
	 * @see org.eclipse.ui.IEditorActionBarContributor#init(IActionBars, IWorkbenchPage)
	 */
	public void init(IActionBars bars, IWorkbenchPage page) {
		super.init(bars, page);
	}

	/**
	 * @see org.eclipse.ui.IEditorActionBarContributor#setActiveEditor(IEditorPart)
	 * When there are multiple instance of the editor open, there are multiple 
	 * instances of the browser control open.  When the active editor changes,
	 * set the target ActiveX browser control   
	 * 
	 */
	public void setActiveEditor(IEditorPart targetEditor) {
		super.setActiveEditor(targetEditor);
		activeXeditor = null;
		if (targetEditor instanceof ActiveXHTMLEditor)
			activeXeditor = (ActiveXHTMLEditor) targetEditor;

	}

}