/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.nature_builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ReadmeVisitor
implements IResourceDeltaVisitor {
    private boolean traceEnabled = false;
    String buildVisitMode = "\t\t\t\t\t>------><visit> ";

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        int type = resource.getType();
        switch (delta.getKind()) {
            case 1: {
                this.traceMsg("< Added: " + resource);
                if (type != 1 || !resource.getName().endsWith(".readme")) break;
                this.processReadme(resource, resource.getParent());
                break;
            }
            case 4: {
                this.traceMsg("< Changed: " + resource);
                if (type != 1 || !resource.getName().endsWith(".readme")) break;
                this.processReadme(resource, resource.getParent());
                break;
            }
            case 2: {
                this.traceMsg("< Removed: " + resource);
            }
        }
        return true;
    }

    public void processReadme(IResource resource, IContainer container) {
        this.traceMsg("Found Readme Resource:");
        this.traceMsg("\t" + resource);
        InputStream stream = this.getReadmeContent((IFile)resource);
        try {
            String fileName = resource.getName();
            fileName = fileName.substring(0, fileName.length() - 7);
            IFile htmlFile = container.getFile((IPath)new Path(String.valueOf(fileName) + ".html"));
            if (!htmlFile.exists()) {
                htmlFile.create(stream, true, null);
                htmlFile.setDerived(true);
            } else {
                htmlFile.setContents(stream, true, false, null);
                htmlFile.setDerived(true);
            }
            this.traceMsg("HTML file created.");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public InputStream getReadmeContent(IFile readmeFile) {
        StringBuffer sbHeader = new StringBuffer();
        sbHeader.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        sbHeader.append("<HTML>\n");
        sbHeader.append("<HEAD>\n");
        sbHeader.append("<TITLE>Readme File as HTML</TITLE>\n");
        sbHeader.append("</HEAD>\n");
        sbHeader.append("<BODY>\n");
        sbHeader.append("<H1>HTML Version of the " + readmeFile.getName() + "</H1>\n");
        sbHeader.append("<P>The <CODE>ReadmeBuilder</CODE> has wrapped the .readme file content in a bit of html.</P>\n");
        sbHeader.append("<H3>Readme file data follows:</H3>\n");
        sbHeader.append("<HR><PRE>\n");
        ByteArrayInputStream header = new ByteArrayInputStream(sbHeader.toString().getBytes());
        StringBuffer sbFooter = new StringBuffer();
        sbFooter.append("</PRE><HR>\n");
        sbFooter.append("<P>A simple approach. We'll leave the fancy formatting of the full content up to you.</P>\n");
        sbFooter.append("<P><STRONG>Enjoy...</STRONG></P>\n");
        sbFooter.append("</BODY>\n");
        sbFooter.append("</HTML>");
        ByteArrayInputStream footer = new ByteArrayInputStream(sbFooter.toString().getBytes());
        SequenceInputStream top = null;
        InputStream total = null;
        try {
            InputStream file = readmeFile.getContents();
            top = new SequenceInputStream(header, file);
            total = new SequenceInputStream(top, footer);
        }
        catch (CoreException coreException) {
            total = new ByteArrayInputStream("Unable to get readme file contents.\n".getBytes());
        }
        return total;
    }

    void traceMsg(String msg) {
        System.out.println(String.valueOf(this.buildVisitMode) + msg);
    }
}

