/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.nature_builder;

import com.ibm.lab.soln.resources.IResourceIDs;
import com.ibm.lab.soln.resources.nature_builder.ReadmeVisitor;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReadmeBuilder
extends IncrementalProjectBuilder {
    private int counter = 0;
    private boolean traceEnabled = false;
    private String buildMode = "<build>";
    private String buildMark = " ----> ";

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        IConfigurationElement[] run = config.getChildren();
        IConfigurationElement[] parms = run[0].getChildren();
        int i = 0;
        while (i < parms.length) {
            this.traceMsg("Passed Parameters: " + parms[i].getAttribute("name") + " = " + parms[i].getAttribute("value"));
            ++i;
        }
    }

    protected void startupOnInitialize() {
        this.traceMsg("Readme Builder Initialize - startupOnInitialize()");
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ++this.counter;
        this.traceMsg("In Readme Builder - build()");
        this.traceMsg("Build for project: " + this.getProject());
        if (kind == 6) {
            this.getDelta(this.getProject());
            this.traceMsg("Build Type: Full Build");
            this.processFull(this.getProject());
            if (this.watchReferecedProjects() != null) {
                this.processFull4ReferencedProjects(this.watchReferecedProjects());
            }
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            this.traceMsg("Process delta for base project");
            if (delta != null) {
                this.processDelta(delta);
            } else {
                this.traceMsg("Build Type: Delta/no-delta Build");
            }
            if (this.watchReferecedProjects() != null) {
                this.processDelta4ReferencedProjects(this.watchReferecedProjects());
            }
        }
        this.traceMsg("<-- End Readme Builder");
        return this.watchReferecedProjects();
    }

    public void checkBuildType(int kind) {
        switch (kind) {
            case 10: {
                this.traceMsg("Build Type: Incremental Build");
                break;
            }
            case 9: {
                this.traceMsg("Build Type: Auto Build");
                break;
            }
            case 6: {
                this.traceMsg("Build Type: Full Build");
            }
        }
    }

    public IProject[] watchReferecedProjects() {
        IProject[] refedProjects;
        try {
            refedProjects = this.getProject().getReferencedProjects();
        }
        catch (CoreException coreException) {
            refedProjects = null;
        }
        if (refedProjects.length != 0) {
            this.traceMsg(">-->Found Referenced Projects" + refedProjects);
            return refedProjects;
        }
        this.traceMsg(">-->No referenced projects found");
        return null;
    }

    public void processFull(IProject iProject) {
        final IFolder readmeFolder = iProject.getFolder(IResourceIDs.README_FOLDER);
        if (readmeFolder.exists()) {
            final ReadmeVisitor visitLogic = new ReadmeVisitor();
            new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ReadmeBuilder.this.traceMsg("Full Build visit(" + resource + ")");
                    if (resource.getType() == 1 && resource.getName().endsWith(".readme")) {
                        visitLogic.processReadme(resource, (IContainer)readmeFolder);
                    }
                    return true;
                }
            };
            IResourceProxyVisitor myProxyVisitor = new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resourceProxy) throws CoreException {
                    ReadmeBuilder.this.traceMsg("Full Build visit(" + resourceProxy.getName() + ") - a proxy");
                    if (resourceProxy.getType() == 1 && resourceProxy.getName().endsWith(".readme")) {
                        visitLogic.processReadme(resourceProxy.requestResource(), (IContainer)readmeFolder);
                    }
                    return true;
                }
            };
            try {
                readmeFolder.accept(myProxyVisitor, 0);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void processFull4ReferencedProjects(IProject[] refedProjects) {
        int i = 0;
        while (i < refedProjects.length) {
            IProject iProject = refedProjects[i];
            this.processFull(iProject);
            ++i;
        }
    }

    public void processDelta(IResourceDelta delta) throws CoreException {
        IResourceDelta focusDelta = delta.findMember(IResourceIDs.README_FOLDER);
        if (focusDelta == null) {
            this.traceMsg("Build Ignored: Delta does not contain " + IResourceIDs.README_FOLDER + " changes.");
        } else {
            this.traceMsg("Build includes a " + IResourceIDs.README_FOLDER + " folder Delta: Time to visit...");
            focusDelta.accept((IResourceDeltaVisitor)new ReadmeVisitor());
        }
    }

    public void processDelta4ReferencedProjects(IProject[] refedProjects) throws CoreException {
        int i = 0;
        while (i < refedProjects.length) {
            IProject iProject = refedProjects[i];
            IResourceDelta refDelta = this.getDelta(iProject);
            this.traceMsg("Process delta for project: " + iProject);
            if (refDelta != null) {
                this.processDelta(refDelta);
            }
            ++i;
        }
    }

    private void traceMsg(String msg) {
        System.out.println(String.valueOf(this.buildMode) + "<" + this.getProject() + "> " + this.counter + "\t\t\t" + this.buildMark + msg);
    }
}

