/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.nature_builder;

import com.ibm.lab.soln.resources.ActionResourceAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;

public class ActionAddCustomNature
extends ActionResourceAction {
    public void run(IAction action) {
        IProject project = (IProject)this.selection.iterator().next();
        try {
            this.addCustomNature(project);
            project.close(null);
            project.open(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.resultError("Soln: Resource - Add CustomNature Request", "Error adding the Custom Nature to the project.");
        }
    }

    public void addCustomNature(IProject project) throws CoreException {
        if (!project.hasNature("com.ibm.lab.soln.resources.customnature")) {
            try {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = "com.ibm.lab.soln.resources.customnature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                this.resultInformation("Soln: Resource - Add CustomNature Request", "CustomNature added to the " + project.getName() + " project.");
            }
            catch (CoreException e) {
                e.printStackTrace();
                this.resultError("Soln: Resource - Add CustomNature Request", "Error adding the CustomNature to the " + project.getName() + " project ");
            }
        } else {
            this.resultError("Soln: Resource - Add CustomNature Request", "The CustomNature is already associated with the " + project.getName() + " project.");
        }
    }
}

