/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources;

import com.ibm.lab.soln.resources.ActionResourceAction;
import com.ibm.lab.soln.resources.EDUResourcesPlugin;
import com.ibm.lab.soln.resources.ListDetailsDialog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ActionProcessResourceTree
extends ActionResourceAction
implements IViewActionDelegate,
IWorkspaceRunnable {
    private String imageFolderName = "images";
    private String readmeFolderName = "readme";
    private String txtFileName = "image_list.txt";
    private String imageFileName = "getstart_b.GIF";

    public void run(IAction action) {
        if (action.getId().equals("projectDetails")) {
            this.showProjectDetails();
        } else if (action.getId().equals("playPath")) {
            this.pathPlay();
        } else if (action.getId().equals("RunnableAction")) {
            try {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, null);
            }
            catch (CoreException coreException) {
                this.resultError("Soln: Resource - Setup Project Structure Request", "Create project structure using a runnable failed.");
            }
        } else {
            IProject project = (IProject)this.selection.iterator().next();
            this.createFolderFile(project);
        }
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        IProject finalProject = (IProject)this.selection.iterator().next();
        this.createFolderFile(finalProject);
    }

    public void showProjectDetails() {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projList = myWorkspaceRoot.getProjects();
        String[] projects = new String[projList.length];
        String[] locations = new String[projList.length];
        int i = 0;
        while (i < projList.length) {
            projects[i] = projList[i].toString();
            locations[i] = projList[i].getLocation().toString();
            ++i;
        }
        ListDetailsDialog lDetails = new ListDetailsDialog(EDUResourcesPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), "Project Location Details", projects, "Projects:", locations, "Locations:");
        lDetails.open();
    }

    public void createFolderFile(IProject project) {
        IFile newTxtFile;
        boolean imageFolderAdded = false;
        boolean txtFileAdded = false;
        boolean imageFileAdded = false;
        boolean readmeFolderAdded = false;
        IFolder imageFolder = project.getFolder(this.imageFolderName);
        imageFolderAdded = this.createFolder(imageFolder);
        IFile newImageFile = imageFolder.getFile(this.imageFileName);
        if (!newImageFile.exists() && (newImageFile = this.copyBasics(imageFolder)).exists()) {
            imageFileAdded = true;
        }
        if (!(newTxtFile = imageFolder.getFile(this.txtFileName)).exists()) {
            try {
                newTxtFile.create(this.getInitialContents(), false, null);
                txtFileAdded = true;
                this.addMarker((IResource)newTxtFile);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        IFolder readmeFolder = project.getFolder(this.readmeFolderName);
        readmeFolderAdded = this.createFolder(readmeFolder);
        String createMsg = "Project Setup Results:";
        createMsg = createMsg.concat(this.folderStatus(imageFolder, imageFolderAdded));
        createMsg = createMsg.concat(this.fileStatus(newTxtFile, txtFileAdded));
        createMsg = createMsg.concat(this.fileStatus(newImageFile, imageFileAdded));
        createMsg = createMsg.concat(this.folderStatus(readmeFolder, readmeFolderAdded));
        this.resultInformation("Soln: Resource - Setup Project Structure Request", createMsg);
    }

    public boolean createFolder(IFolder newFolder) {
        if (!newFolder.exists()) {
            try {
                newFolder.create(true, true, null);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String folderStatus(IFolder imageFolder, boolean imageFolderAdded) {
        String createMsg = null;
        createMsg = imageFolderAdded ? "\n\t> + folder added: " + imageFolder.getName() : "\n\t> = folder already existed: " + imageFolder.getName();
        return createMsg;
    }

    public String fileStatus(IFile txtFile, boolean txtFileAdded) {
        String createMsg = null;
        createMsg = txtFileAdded ? "\n\t> + file added: " + txtFile.getName() : "\n\t> = file already existed: " + txtFile.getName();
        return createMsg;
    }

    public InputStream getInitialContents() {
        StringBuffer sb = new StringBuffer();
        sb.append("image_list.txt\n");
        sb.append("A good place to describe your images\n\n");
        sb.append("Image File name \t\t Description\n");
        sb.append("--------------- \t\t -----------\n");
        sb.append("getstart_b.GIF  \t\t glowing lamp image\n ");
        sb.append("        \n ");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void addMarker(IResource resource) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
            marker.setAttribute("charStart", 153);
            marker.setAttribute("charEnd", 154);
            marker.setAttribute("message", (Object)("New " + this.txtFileName + " added"));
        }
        catch (CoreException coreException) {
            this.resultError("Soln: Resource - Marker Create", "Creation of marker failed.");
        }
    }

    public IFile copyBasics(IFolder folder) {
        IFile imageFile = folder.getFile(this.imageFileName);
        try {
            imageFile.create(EDUResourcesPlugin.getDefault().openStream((IPath)new Path(String.valueOf(this.imageFolderName) + "/" + this.imageFileName)), true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageFile;
    }

    public void pathPlay() {
        IResource res = (IResource)this.selection.getFirstElement();
        String pathList = new String();
        pathList = pathList.concat("Resource used: " + res + "\n");
        this.traceEnabled = false;
        String[] methods = new String[7];
        String[] values = new String[7];
        methods[0] = "res.getLocation.toString()";
        values[0] = res.getLocation().toString();
        methods[1] = "res.getFullPath().toString()";
        values[1] = res.getFullPath().toString();
        methods[2] = "res.getFullPath().toOSString()";
        values[2] = res.getFullPath().toOSString();
        methods[3] = "res.getProjectRelativePath().toString()";
        values[3] = res.getProjectRelativePath().toString();
        methods[4] = "res.getProjectRelativePath().makeAbsolute().toString()";
        values[4] = res.getProjectRelativePath().makeAbsolute().toString();
        methods[5] = "res.getFullPath().makeRelative().toString()";
        values[5] = res.getFullPath().makeRelative().toString();
        methods[6] = "res.getFullPath().makeUNC(true).toString()";
        values[6] = res.getFullPath().makeUNC(true).toString();
        ListDetailsDialog lDetails = new ListDetailsDialog(EDUResourcesPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), "Path Value List for: " + res, methods, "Path Method:", values, "Path Value:");
        lDetails.open();
    }

    public void init(IViewPart view) {
    }
}

