/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.newWizard.rcl;

import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceDeltaPrinter
implements IResourceDeltaVisitor {
    private boolean traceEnabled = true;
    String rclMode = "\tDeltaPrinter:  ";

    public ResourceDeltaPrinter() {
    }

    public ResourceDeltaPrinter(String mode) {
        this();
        this.rclMode = String.valueOf(mode) + " -> ";
    }

    public boolean visit(IResourceDelta delta) {
        IResource res = delta.getResource();
        ResourceDelta cfr_ignored_0 = (ResourceDelta)delta;
        switch (delta.getKind()) {
            case 1: {
                this.traceMsg("\tResource " + res.getFullPath() + " was added.");
                break;
            }
            case 2: {
                this.traceMsg("\tResource " + res.getFullPath() + " was removed.");
                break;
            }
            case 4: {
                this.traceMsg("\tResource " + res.getFullPath() + " has changed.");
            }
        }
        this.testFlags(delta.getFlags());
        if (delta.getKind() == 4 | delta.getKind() == 1 && (delta.getFlags() & 0x20000) != 0) {
            try {
                this.processMarkerSet(res, delta);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void testFlags(int eventFlag) {
        if ((eventFlag & 0x4000) != 0) {
            this.traceMsg("\tResourceDelta Kind: Opened");
        }
        if ((eventFlag & 0x100) != 0) {
            this.traceMsg("\tResourceDelta Kind: Content Change");
        }
        if ((eventFlag & 0x40000) != 0) {
            this.traceMsg("\tResourceDelta Kind: Content Replaced");
        }
        if ((eventFlag & 2) != 0) {
            this.traceMsg("\tResourceDelta Kind: Removed");
        }
        if ((eventFlag & 0x20000) != 0) {
            this.traceMsg("\tResourceDelta Kind: Marker Change");
        }
    }

    public void processMarkerSet(IResource res, IResourceDelta delta) throws CoreException {
        IMarkerDelta[] markers = delta.getMarkerDeltas();
        int i = 0;
        while (i < markers.length) {
            IMarkerDelta markerDelta = markers[i];
            int kind = markerDelta.getKind();
            this.traceMsg("\t\t Marker delta kind: " + this.getKind(kind));
            IMarker marker = markerDelta.getMarker();
            if (marker.exists()) {
                this.traceMsg("\t\t Marker type: " + marker.getType());
                this.traceMsg("\t\t Marker content: " + marker.getAttributes().values());
            }
            ++i;
        }
    }

    private String getKind(int kind) {
        switch (kind) {
            case 1: {
                return "Added";
            }
            case 4: {
                return "Changed";
            }
            case 2: {
                return "Removed";
            }
        }
        return "Other";
    }

    void traceMsg(String msg) {
        if (this.traceEnabled) {
            System.out.println(String.valueOf(this.rclMode) + msg);
        }
    }
}

