/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.dialogs;

import com.ibm.lab.soln.dialogs.StructureNewFileWizardPage;
import com.ibm.lab.soln.dialogs.StructureNewFolderWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class StructureInitPage
extends WizardPage
implements SelectionListener {
    private boolean traceEnabled = true;
    private Wizard currentWizard;
    private Button folderButton;
    private Button fileButton;
    private Button noneButton;
    private IStructuredSelection selection;
    private boolean nextPageExists;

    public StructureInitPage(String pageName, IStructuredSelection selection, Wizard parent) {
        super(pageName);
        this.selection = selection;
        this.currentWizard = parent;
        this.setDescription("Choose the resource creation page you want to see.");
        this.setTitle("Project Structure Navigation");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)compositeData);
        this.createNextPageSelection(composite);
        this.setControl((Control)composite);
    }

    private Group createNextPageSelection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Select the resource type you wish to create:");
        GridData gData = new GridData(768);
        group.setLayoutData((Object)gData);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 1;
        group.setLayout((Layout)gLayout);
        this.folderButton = this.createRadioButton((Composite)group, "Create a fo&lder");
        this.fileButton = this.createRadioButton((Composite)group, "Create a f&ile");
        return group;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData(768);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.folderButton.getSelection()) {
            System.out.println("new folder request");
            this.nextPageExists = true;
        } else if (this.fileButton.getSelection()) {
            System.out.println("new file request");
            this.nextPageExists = true;
        }
        this.getWizard().getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        if (this.folderButton.getSelection()) {
            this.currentWizard.addPage((IWizardPage)new StructureNewFolderWizardPage("fold", this.selection, this.currentWizard));
            return super.getNextPage();
        }
        if (this.fileButton.getSelection()) {
            this.currentWizard.addPage((IWizardPage)new StructureNewFileWizardPage("file", this.selection, this.currentWizard));
            return super.getNextPage();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return this.nextPageExists;
    }

    private void traceMsg(String msg) {
        System.out.println(msg);
    }
}

