/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.jface;

import com.ibm.lab.soln.jface.JFaceComponent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class MembersDialog
extends Dialog {
    private IContainer focusFolder;

    public MembersDialog(Shell parentShell) {
        super(parentShell);
    }

    public MembersDialog(Shell shell, IContainer readmeFolder) {
        this(shell);
        this.focusFolder = readmeFolder;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("JFace Component Dialog");
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.justify = true;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)fillLayout);
        Composite txtArea = new Composite(dialogArea, 2048);
        txtArea.setLayout((Layout)fillLayout);
        Composite viewerArea = new Composite(dialogArea, 2048);
        viewerArea.setLayout((Layout)fillLayout);
        Label input = new Label(txtArea, 0);
        input.setText(this.focusFolder.toString());
        Label selected = new Label(txtArea, 0);
        selected.setText("");
        this.addJFaceComponent(viewerArea, selected);
        return dialogArea;
    }

    private void addJFaceComponent(Composite viewerArea, final Label selected) {
        JFaceComponent jcomp = this.createJFaceComponent(viewerArea);
        jcomp.configureViewer();
        jcomp.setInput(this.focusFolder);
        jcomp.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println(">Dialog hears selection" + event.getSelection());
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                selected.setText("");
                if (ssel != null && ssel.getFirstElement() instanceof IResource) {
                    IResource res = (IResource)ssel.getFirstElement();
                    selected.setText(res.getName());
                }
            }
        });
    }

    private JFaceComponent createJFaceComponent(Composite composite) {
        String opt = new String("1");
        if (opt.equals("1")) {
            JFaceComponent jfaceComp = new JFaceComponent(composite);
            return jfaceComp;
        }
        Table table = new Table(composite, 2818);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        JFaceComponent jfaceComp = new JFaceComponent(table);
        return jfaceComp;
    }
}

