/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.jface;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JfacePlugin
extends AbstractUIPlugin {
    private IResource foundResource = null;
    private static JfacePlugin plugin;
    private ResourceBundle resourceBundle;

    public JfacePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.lab.soln.jface.JfacePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static JfacePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IResource findByName(String name) {
        IProject[] projectList = JfacePlugin.getWorkspace().getRoot().getProjects();
        NamedVisitor myVisitor = new NamedVisitor(name);
        int i = 0;
        while (i < projectList.length) {
            IProject project = projectList[i];
            IResource resource = (IResource)project;
            try {
                resource.accept((IResourceProxyVisitor)myVisitor, 0);
                if (this.getFoundResource() != null) {
                    return this.getFoundResource();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return this.getFoundResource();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JfacePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    protected void setFoundResource(IResource foundResource) {
        this.foundResource = foundResource;
    }

    protected IResource getFoundResource() {
        return this.foundResource;
    }

    private final class NamedVisitor
    implements IResourceProxyVisitor {
        private final String name;

        NamedVisitor(String name) {
            this.name = name;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getName().equals(this.name)) {
                JfacePlugin.this.setFoundResource(proxy.requestResource());
                return false;
            }
            return true;
        }
    }
}

